/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.network.client;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.common.config.Config;
import net.sixik.sdmshoprework.common.data.LimiterData;
import net.sixik.sdmshoprework.common.integration.KubeJS.KubeJSHelper;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.network.ShopNetwork;
import net.sixik.sdmshoprework.network.client.SendEntryLimitS2C;

public class SendBuyShopEntryC2S
extends BaseC2SMessage {
    private final UUID tabUUID;
    private final UUID entryUUID;
    private final int count;

    public SendBuyShopEntryC2S(UUID tabUUID, UUID entryUUID, int count) {
        this.tabUUID = tabUUID;
        this.entryUUID = entryUUID;
        this.count = count;
    }

    public SendBuyShopEntryC2S(FriendlyByteBuf buf) {
        this.tabUUID = buf.m_130259_();
        this.entryUUID = buf.m_130259_();
        this.count = buf.readInt();
    }

    public MessageType getType() {
        return ShopNetwork.SEND_BUY_ENTRY;
    }

    public void write(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130077_(this.tabUUID);
        friendlyByteBuf.m_130077_(this.entryUUID);
        friendlyByteBuf.writeInt(this.count);
    }

    public void handle(NetworkManager.PacketContext packetContext) {
        int counBuy;
        Map buyDataMap;
        ShopTab shopTab = ShopBase.SERVER.getShopTab(this.tabUUID);
        AbstractShopEntry entry = shopTab.getShopEntry(this.entryUUID);
        if (!entry.getEntryType().canExecute(packetContext.getPlayer(), entry.isSell, this.count, entry)) {
            SDMShopRework.LOGGER.warn("Player {} tried to buy entry {} from tab {} which is not allowed", new Object[]{packetContext.getPlayer().m_36316_().getName(), entry.entryUUID, shopTab.shopTabUUID});
            return;
        }
        if (shopTab.limit != 0) {
            buyDataMap = LimiterData.SERVER.PLAYER_TAB_DATA.getOrDefault(shopTab.globalLimit ? LimiterData.defaul_ : packetContext.getPlayer().m_36316_().getId(), new HashMap());
            counBuy = buyDataMap.getOrDefault(this.tabUUID, 0);
            if (counBuy > shopTab.limit) {
                return;
            }
            buyDataMap.put(this.tabUUID, counBuy + 1 * this.count);
            LimiterData.SERVER.PLAYER_TAB_DATA.put(shopTab.globalLimit ? LimiterData.defaul_ : packetContext.getPlayer().m_36316_().getId(), buyDataMap);
            new SendEntryLimitS2C(LimiterData.SERVER.serializeClient(packetContext.getPlayer().m_36316_().getId())).sendTo((ServerPlayer)packetContext.getPlayer());
            LimiterData.SERVER.save(packetContext.getPlayer().m_20194_());
            if (shopTab.globalLimit) {
                for (ServerPlayer player : packetContext.getPlayer().m_20194_().m_6846_().m_11314_()) {
                    new SendEntryLimitS2C(LimiterData.SERVER.serializeClient(player.m_36316_().getId())).sendTo(player);
                }
            }
        }
        if (entry.limit != 0) {
            buyDataMap = LimiterData.SERVER.PLAYER_ENTRY_DATA.getOrDefault(entry.globalLimit ? LimiterData.defaul_ : packetContext.getPlayer().m_36316_().getId(), new HashMap());
            counBuy = buyDataMap.getOrDefault(this.entryUUID, 0);
            if (counBuy > entry.limit) {
                return;
            }
            buyDataMap.put(this.entryUUID, counBuy + 1 * this.count);
            LimiterData.SERVER.PLAYER_ENTRY_DATA.put(entry.globalLimit ? LimiterData.defaul_ : packetContext.getPlayer().m_36316_().getId(), buyDataMap);
            new SendEntryLimitS2C(LimiterData.SERVER.serializeClient(packetContext.getPlayer().m_36316_().getId())).sendTo((ServerPlayer)packetContext.getPlayer());
            LimiterData.SERVER.save(packetContext.getPlayer().m_20194_());
            if (entry.globalLimit) {
                for (ServerPlayer player : packetContext.getPlayer().m_20194_().m_6846_().m_11314_()) {
                    new SendEntryLimitS2C(LimiterData.SERVER.serializeClient(player.m_36316_().getId())).sendTo(player);
                }
            }
        }
        long defaultPrice = entry.entryPrice;
        long defaultCount = entry.entryCount;
        if (entry.isSell) {
            try {
                if (Platform.isModLoaded((String)"kubejs")) {
                    KubeJSHelper.postEvent(packetContext.getPlayer(), entry, this.count, KubeJSHelper.EventType.SELL);
                }
                entry.getEntryType().sell(packetContext.getPlayer(), this.count, entry);
                if (defaultPrice != entry.entryPrice || defaultCount != (long)entry.entryCount) {
                    ShopBase.SERVER.syncShop(packetContext.getPlayer().m_20194_());
                }
            }
            catch (Exception e) {
                SDMShopRework.printStackTrace("", e);
            }
        } else {
            try {
                if (Platform.isModLoaded((String)"kubejs")) {
                    KubeJSHelper.postEvent(packetContext.getPlayer(), entry, this.count, KubeJSHelper.EventType.BUY);
                }
                entry.getEntryType().buy(packetContext.getPlayer(), this.count, entry);
                if (defaultPrice != entry.entryPrice || defaultCount != (long)entry.entryCount) {
                    ShopBase.SERVER.syncShop(packetContext.getPlayer().m_20194_());
                }
            }
            catch (Exception e) {
                SDMShopRework.printStackTrace("", e);
            }
        }
        if (((Boolean)Config.SEND_NOTIFY.get()).booleanValue()) {
            entry.getEntryType().sendNotifiedMessage(packetContext.getPlayer());
        }
        packetContext.getPlayer().m_6330_(SDMShopRework.BUY_SOUND, SoundSource.VOICE, 1.0f, 1.0f);
    }
}

