/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.type;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.SDMItemHelper;
import org.jetbrains.annotations.NotNull;

public class ShopTagEntryType
extends AbstractShopEntryType {
    public static ResourceLocation DEFAULT = new ResourceLocation("minecraft", "anvil");
    public ResourceLocation tagKey;
    public ItemStack iconPath;

    protected ShopTagEntryType(ResourceLocation tagKey) {
        this.tagKey = tagKey;
        this.iconPath = Items.f_42728_.m_7968_();
    }

    protected ShopTagEntryType(ResourceLocation tagKey, ItemStack iconPath) {
        this.tagKey = tagKey;
        this.iconPath = iconPath;
    }

    public static ShopTagEntryType of(ResourceLocation tagKey) {
        return new ShopTagEntryType(tagKey);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup group) {
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
        group.addEnum("tags", (Object)this.tagKey.toString(), v -> {
            this.tagKey = new ResourceLocation(v);
        }, this.getTags());
    }

    @Override
    public Icon getCreativeIcon() {
        return ItemIcon.getItemIcon((Item)Items.f_42656_);
    }

    public NameMap<String> getTags() {
        ArrayList str = new ArrayList();
        ForgeRegistries.ITEMS.tags().getTagNames().forEach(s -> str.add(s.f_203868_().toString()));
        return NameMap.of((Object)DEFAULT.toString(), str).create();
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopTagEntryType(this.tagKey, this.iconPath);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.itemtag");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128359_("tagKey", this.tagKey.toString());
        nbt.m_128365_("iconPath", (Tag)this.iconPath.serializeNBT());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.tagKey = new ResourceLocation(nbt.m_128461_("tagKey"));
        this.iconPath = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("iconPath"));
    }

    @Override
    public String getId() {
        return "itemTag";
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        int amount;
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        @NotNull ITag tag = ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.tagKey));
        for (int index = 0; index < player.m_150109_().m_6643_(); ++index) {
            if (!player.m_150109_().m_8020_(index).m_204117_(tag.getKey())) continue;
            stackList.add(player.m_150109_().m_8020_(index));
        }
        int amountItems = 0;
        for (ItemStack item : stackList) {
            amountItems += item.m_41613_();
        }
        int n = amount = amountItems >= entry.entryCount * countSell ? entry.entryCount * countSell : 0;
        if (amountItems == 0 || amount == 0) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        if (SDMItemHelper.sellItem(player, amount, (TagKey<Item>)tag.getKey())) {
            SDMShopR.addMoney(player, entry.entryPrice * (long)countSell);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        if (isSell) {
            @NotNull ITag tag = ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.tagKey));
            int countItems = 0;
            Inventory inventory = Minecraft.m_91087_().f_91074_.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!inventory.m_8020_(i).m_204117_(tag.getKey())) continue;
                countItems += inventory.m_8020_(i).m_41613_();
            }
            return countItems >= entry.entryCount * countSell;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (isSell) {
            int countItems = 0;
            Inventory inventory = Minecraft.m_91087_().f_91074_.m_150109_();
            @NotNull ITag tag = ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)this.tagKey));
            if (entry.entryPrice == 0L) {
                return 127;
            }
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                if (!inventory.m_8020_(i).m_204117_(tag.getKey())) continue;
                countItems += inventory.m_8020_(i).m_41613_();
            }
            return countItems / entry.entryCount;
        }
        return 0;
    }

    @Override
    public AbstractShopEntryType.SellType getSellType() {
        return AbstractShopEntryType.SellType.ONLY_SELL;
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopTagEntryType(DEFAULT);
        }
    }
}

