/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.type;

import daripher.skilltree.capability.skill.PlayerSkillsProvider;
import daripher.skilltree.network.NetworkDispatcher;
import daripher.skilltree.network.message.SyncPlayerSkillsMessage;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopSkillTreeEntryType
extends AbstractShopEntryType {
    private ItemStack iconPath = Items.f_42127_.m_7968_();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup group) {
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopSkillTreeEntryType();
    }

    @Override
    public String getModNameForContextMenu() {
        return "Passive Skill Tree";
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.integration.passiveskilltree");
    }

    @Override
    public List<Component> getDescriptionForContextMenu() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"sdmr.shop.entry.creator.type.pstType.description"));
        return list;
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPathNew");
    }

    @Override
    public Icon getCreativeIcon() {
        return Icon.getIcon((String)"skilltree:textures/item/amnesia_scroll.png");
    }

    @Override
    public String getModId() {
        return "skilltree";
    }

    @Override
    public String getId() {
        return "pstType";
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (PlayerSkillsProvider.get((Player)player).getSkillPoints() >= entry.entryCount * countSell) {
                PlayerSkillsProvider.get((Player)player).setSkillPoints(PlayerSkillsProvider.get((Player)player).getSkillPoints() - entry.entryCount * countSell);
                NetworkDispatcher.network_channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncPlayerSkillsMessage(player));
                SDMShopR.setMoney(player, SDMShopR.getMoney(player) + entry.entryPrice * (long)countSell);
            }
        }
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (entry.entryPrice * (long)countBuy <= SDMShopR.getMoney(player)) {
                PlayerSkillsProvider.get((Player)player).setSkillPoints(PlayerSkillsProvider.get((Player)player).getSkillPoints() + entry.entryCount * countBuy);
                NetworkDispatcher.network_channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncPlayerSkillsMessage(player));
                SDMShopR.setMoney(player, SDMShopR.getMoney(player) - entry.entryPrice * (long)countBuy);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        if (isSell) {
            return PlayerSkillsProvider.get((Player)player).getSkillPoints() >= entry.entryCount * countSell;
        }
        long playerMoney = SDMShopR.getMoney(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (isSell) {
            return PlayerSkillsProvider.get((Player)player).getSkillPoints() / entry.entryCount;
        }
        long playerMoney = SDMShopR.getMoney(player);
        if (entry.entryPrice == 0L) {
            return 127;
        }
        return (int)(playerMoney / entry.entryPrice);
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopSkillTreeEntryType();
        }
    }
}

