/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.type;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopGameStagesEntryType
extends AbstractShopEntryType {
    public String gameStage;
    private ItemStack iconPath = Items.f_42127_.m_7968_();

    public ShopGameStagesEntryType(String gameStage) {
        this.gameStage = gameStage;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup group) {
        group.addString("gameStage", this.gameStage, v -> {
            this.gameStage = v;
        }, "");
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopGameStagesEntryType(this.gameStage);
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.integration.gamestage");
    }

    @Override
    public List<Component> getDescriptionForContextMenu() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"sdmr.shop.entry.creator.type.stageType.description"));
        return list;
    }

    @Override
    public String getModNameForContextMenu() {
        return "Game Stages";
    }

    @Override
    public Icon getCreativeIcon() {
        return Icons.CONTROLLER;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128359_("gameStage", this.gameStage);
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.gameStage = nbt.m_128461_("gameStage");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPathNew");
    }

    @Override
    public String getId() {
        return "stageType";
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            long playerMoney = SDMShopR.getMoney(player);
            if (!GameStageHelper.hasStage((Player)player, (String)this.gameStage)) {
                return;
            }
            GameStageHelper.removeStage((ServerPlayer)serverPlayer, (String[])new String[]{this.gameStage});
            SDMShopR.setMoney(player, playerMoney + entry.entryPrice);
        }
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            long playerMoney = SDMShopR.getMoney(player);
            if (playerMoney < entry.entryPrice) {
                return;
            }
            GameStageHelper.addStage((ServerPlayer)serverPlayer, (String[])new String[]{this.gameStage});
            SDMShopR.setMoney(player, playerMoney - entry.entryPrice);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        if (GameStageHelper.hasStage((Player)player, (String)this.gameStage)) {
            return false;
        }
        long playerMoney = SDMShopR.getMoney(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    public String getModId() {
        return "gamestages";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (GameStageHelper.hasStage((Player)player, (String)this.gameStage)) {
            return 0;
        }
        long playerMoney = SDMShopR.getMoney(player);
        if (entry.entryPrice == 0L) {
            return 1;
        }
        return (int)(playerMoney / entry.entryPrice) >= 1 ? 1 : 0;
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopGameStagesEntryType("");
        }
    }
}

