/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.type.ManaAndArtifice;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.recipes.progression.ProgressionCondition;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopMNATierEntryType
extends AbstractShopEntryType {
    public int tierID;
    public boolean random = false;
    private ItemStack iconPath = Items.f_42127_.m_7968_();
    public boolean resetProgression = false;

    public ShopMNATierEntryType(int tierID) {
        this.tierID = tierID;
    }

    protected ShopMNATierEntryType(int tierID, boolean random, ItemStack iconPath, boolean resetProgression) {
        this.tierID = tierID;
        this.random = random;
        this.iconPath = iconPath;
        this.resetProgression = resetProgression;
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup group) {
        group.addInt("mnatierID", this.tierID, v -> {
            this.tierID = v;
        }, 1, 1, 5);
        group.addBool("mnarandom", this.random, v -> {
            this.random = v;
        }, false);
        group.addBool("mnaresetProgression", this.resetProgression, v -> {
            this.resetProgression = v;
        }, false);
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
    }

    @Override
    public Icon getCreativeIcon() {
        return Icon.getIcon((String)"mna:textures/item/eldrin_sight_unguent.png");
    }

    @Override
    public String getModId() {
        return "mna";
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopMNATierEntryType(this.tierID, this.random, this.iconPath, this.resetProgression);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.mnatier");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("tierID", this.tierID);
        nbt.m_128379_("random", this.random);
        nbt.m_128379_("resetProgression", this.resetProgression);
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.tierID = nbt.m_128451_("tierID");
        this.random = nbt.m_128471_("random");
        this.resetProgression = nbt.m_128471_("resetProgression");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPathNew");
    }

    @Override
    public String getId() {
        return "mnaTierType";
    }

    @Override
    public String getModNameForContextMenu() {
        return "Mana And Artifice";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (isSell) {
            IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
            if (progression.getTier() != this.tierID) {
                return 0;
            }
            return 1;
        }
        long playerMoney = SDMShopR.getMoney(player);
        return (int)(playerMoney / entry.entryPrice) >= 1 ? 1 : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        if (!isSell) {
            if (SDMShopR.getMoney(player) < entry.entryPrice) {
                return false;
            }
            return progression.getTier() != 5 && progression.getTier() < this.tierID;
        }
        return progression.getTier() == this.tierID;
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        List progressionConditionList = ProgressionCondition.get((Level)player.m_9236_(), (int)progression.getTier());
        if (progression.getTier() < this.tierID && progression.getTier() != 5) {
            if (this.random) {
                RandomSource source = RandomSource.m_216327_();
                int d1 = source.m_216339_(progression.getTier(), 5);
                progression.setTier(d1, player);
            } else {
                progression.setTier(this.tierID, player);
            }
            long money = SDMShopR.getMoney(player);
            SDMShopR.setMoney(player, money - entry.entryPrice);
        }
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        if (progression.getTier() == this.tierID && progression.getTier() > 1) {
            progression.setTier(progression.getTier() - 1, player);
            List progressionConditionList = ProgressionCondition.get((Level)player.m_9236_(), (int)(progression.getTier() + 1));
            if (this.resetProgression) {
                for (ProgressionCondition condition : progressionConditionList) {
                    progression.getCompletedProgressionSteps().remove(condition.m_6423_());
                }
                progressionConditionList = ProgressionCondition.get((Level)player.m_9236_(), (int)progression.getTier());
                for (ProgressionCondition condition : progressionConditionList) {
                    progression.getCompletedProgressionSteps().remove(condition.m_6423_());
                }
            }
        }
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopMNATierEntryType(0);
        }
    }
}

