/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.type.ManaAndArtifice;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.recipes.progression.ProgressionCondition;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopMNAProgressionEntryType
extends AbstractShopEntryType {
    public int progressionID;
    public boolean random = false;
    private ItemStack iconPath = Items.f_42127_.m_7968_();

    public ShopMNAProgressionEntryType(int progressionID) {
        this.progressionID = progressionID;
    }

    protected ShopMNAProgressionEntryType(int progressionID, boolean random, ItemStack iconPath) {
        this.progressionID = progressionID;
        this.random = random;
        this.iconPath = iconPath;
    }

    @Override
    public String getModId() {
        return "mna";
    }

    @Override
    public AbstractShopEntryType.SellType getSellType() {
        return AbstractShopEntryType.SellType.ONLY_BUY;
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup group) {
        IPlayerProgression progression = (IPlayerProgression)Minecraft.m_91087_().f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        List progressionConditionList = ProgressionCondition.get((Level)Minecraft.m_91087_().f_91074_.m_9236_(), (int)progression.getTier());
        group.addInt("mnaprogressionID", this.progressionID, v -> {
            this.progressionID = v;
        }, 1, 1, progressionConditionList.size());
        group.addBool("mnarandom", this.random, v -> {
            this.random = v;
        }, false);
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
    }

    @Override
    public Icon getCreativeIcon() {
        return Icon.getIcon((String)"mna:textures/item/eldrin_sight_unguent.png");
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopMNAProgressionEntryType(this.progressionID, this.random, this.iconPath);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.mnaprogression");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("progressionID", this.progressionID);
        nbt.m_128379_("random", this.random);
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.progressionID = nbt.m_128451_("progressionID");
        this.random = nbt.m_128471_("random");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPathNew");
    }

    @Override
    public String getId() {
        return "mnaProgressionType";
    }

    @Override
    public String getModNameForContextMenu() {
        return "Mana And Artifice";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        long playerMoney = SDMShopR.getMoney(player);
        return (int)(playerMoney / entry.entryPrice) >= 1 ? 1 : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        if (SDMShopR.getMoney(player) < entry.entryPrice) {
            return false;
        }
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        List progressionConditionList = ProgressionCondition.get((Level)player.m_9236_(), (int)progression.getTier());
        for (ProgressionCondition condition : progressionConditionList) {
            if (progression.getCompletedProgressionSteps().contains(condition.m_6423_())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        List progressionConditionList = ProgressionCondition.get((Level)player.m_9236_(), (int)progression.getTier());
        if (this.random) {
            RandomSource source = RandomSource.m_216327_();
            int notFound = 0;
            while (true) {
                if (notFound >= 40) {
                    return;
                }
                int randomInt = source.m_188503_(progressionConditionList.size());
                ProgressionCondition condition = (ProgressionCondition)progressionConditionList.get(randomInt);
                if (!progression.getCompletedProgressionSteps().contains(condition.m_6423_())) {
                    progression.addTierProgressionComplete(condition.m_6423_());
                    long money = SDMShopR.getMoney(player);
                    SDMShopR.setMoney(player, money - entry.entryPrice);
                    return;
                }
                ++notFound;
            }
        }
        ProgressionCondition condition = (ProgressionCondition)progressionConditionList.get(this.progressionID);
        if (!progression.getCompletedProgressionSteps().contains(condition.m_6423_())) {
            progression.addTierProgressionComplete(condition.m_6423_());
            long money = SDMShopR.getMoney(player);
            SDMShopR.setMoney(player, money - entry.entryPrice);
        }
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopMNAProgressionEntryType(0);
        }
    }
}

