/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.type.ManaAndArtifice;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopMNALevelEntryType
extends AbstractShopEntryType {
    protected static int maxLevel = 75;
    public int level;
    private ItemStack iconPath = Items.f_42127_.m_7968_();

    public ShopMNALevelEntryType() {
    }

    protected ShopMNALevelEntryType(int level, ItemStack iconPath) {
        this.level = level;
        this.iconPath = iconPath;
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup group) {
        group.addInt("mnalevel", this.level, v -> {
            this.level = v;
        }, 1, 1, 75);
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
    }

    @Override
    public Icon getCreativeIcon() {
        return Icon.getIcon((String)"mna:textures/item/eldrin_sight_unguent.png");
    }

    @Override
    public String getModId() {
        return "mna";
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopMNALevelEntryType(this.level, this.iconPath);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.mnamagiclevel");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("level", this.level);
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.level = nbt.m_128451_("level");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPathNew");
    }

    @Override
    public String getId() {
        return "mnaLevelType";
    }

    @Override
    public String getModNameForContextMenu() {
        return "Mana And Artifice";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        IPlayerMagic playerMagic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).resolve().get();
        if (playerMagic != null) {
            if (isSell) {
                return playerMagic.getMagicLevel() / this.level;
            }
            long playerMoney = SDMShopR.getMoney(player);
            int count = (int)(playerMoney / entry.entryPrice);
            if (playerMagic.getMagicLevel() + count * this.level > 75) {
                return (playerMagic.getMagicLevel() + count * this.level - playerMagic.getMagicLevel()) / this.level;
            }
            return count;
        }
        return 0;
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        IPlayerMagic playerMagic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).resolve().get();
        if (playerMagic != null) {
            int d1 = playerMagic.getMagicLevel() + this.level * countBuy;
            if (d1 > maxLevel) {
                d1 = 75;
            }
            playerMagic.setMagicLevel(player, d1);
            playerMagic.setMagicXP(playerMagic.getXPForLevel(d1));
            long playerMoney = SDMShopR.getMoney(player);
            SDMShopR.setMoney(player, playerMoney - entry.entryPrice);
        }
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        IPlayerMagic playerMagic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).resolve().get();
        if (playerMagic != null) {
            int d1 = playerMagic.getMagicLevel() - this.level * countSell;
            if (d1 < 0) {
                d1 = 0;
            }
            playerMagic.setMagicLevel(player, d1);
            playerMagic.setMagicXP(playerMagic.getXPForLevel(d1));
            long playerMoney = SDMShopR.getMoney(player);
            SDMShopR.setMoney(player, playerMoney + entry.entryPrice);
        }
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopMNALevelEntryType();
        }
    }
}

