/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.type.ManaAndArtifice;

import com.mna.Registries;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopMNAFactionEntryType
extends AbstractShopEntryType {
    public String factionID;
    public boolean random = false;
    public boolean needNonFaction = false;
    private ItemStack iconPath = Items.f_42127_.m_7968_();

    public ShopMNAFactionEntryType(String factionID) {
        this.factionID = factionID;
    }

    protected ShopMNAFactionEntryType(String factionID, boolean random, ItemStack iconPath, boolean needNonFaction) {
        this.factionID = factionID;
        this.random = random;
        this.iconPath = iconPath;
        this.needNonFaction = needNonFaction;
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup group) {
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
        group.addString("mnafactionID", this.factionID, v -> {
            this.factionID = v;
        }, "mna:none");
        group.addBool("mnaneedNonFaction", this.needNonFaction, v -> {
            this.needNonFaction = v;
        }, false);
    }

    @Override
    public Icon getCreativeIcon() {
        return Icon.getIcon((String)"mna:textures/item/eldrin_sight_unguent.png");
    }

    @Override
    public String getModId() {
        return "mna";
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopMNAFactionEntryType(this.factionID, this.random, this.iconPath, this.needNonFaction);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.mnafaction");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128359_("factionID", this.factionID);
        nbt.m_128379_("random", this.random);
        nbt.m_128379_("needNonFaction", this.needNonFaction);
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.factionID = nbt.m_128461_("factionID");
        this.random = nbt.m_128471_("random");
        this.needNonFaction = nbt.m_128471_("needNonFaction");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPathNew");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        try {
            IFaction faction = (IFaction)((IForgeRegistry)Registries.Factions.get()).getValue(new ResourceLocation(this.factionID));
            IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
            if (faction != null) {
                if (isSell && progression.getAlliedFaction().is(new ResourceLocation(this.factionID))) {
                    return 1;
                }
                if (this.needNonFaction && !progression.getAlliedFaction().is(new ResourceLocation("mna:none"))) {
                    return 0;
                }
                long playerMoney = SDMShopR.getMoney(player);
                if (entry.entryPrice == 0L) {
                    return 1;
                }
                return (int)(playerMoney / entry.entryPrice) >= 1 ? 1 : 0;
            }
        }
        catch (Exception e) {
            SDMShopRework.LOGGER.error(e.toString());
        }
        return 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        IFaction faction = (IFaction)((IForgeRegistry)Registries.Factions.get()).getValue(new ResourceLocation(this.factionID));
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        if (faction != null) {
            if (isSell && progression.getAlliedFaction().is(new ResourceLocation(this.factionID))) {
                return true;
            }
            if (this.needNonFaction && !progression.getAlliedFaction().is(new ResourceLocation("mna:none"))) {
                return false;
            }
            long playerMoney = SDMShopR.getMoney(player);
            return (int)(playerMoney / entry.entryPrice) > 1;
        }
        return false;
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        IFaction faction = (IFaction)((IForgeRegistry)Registries.Factions.get()).getValue(new ResourceLocation(this.factionID));
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        progression.setAlliedFaction(faction, player);
        long playerMoney = SDMShopR.getMoney(player);
        SDMShopR.setMoney(player, playerMoney - entry.entryPrice);
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        IFaction faction = (IFaction)((IForgeRegistry)Registries.Factions.get()).getValue(new ResourceLocation("mna:none"));
        IPlayerProgression progression = (IPlayerProgression)player.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
        progression.setAlliedFaction(faction, player);
        long playerMoney = SDMShopR.getMoney(player);
        SDMShopR.setMoney(player, playerMoney + entry.entryPrice);
    }

    @Override
    public String getId() {
        return "mnaFactionType";
    }

    @Override
    public String getModNameForContextMenu() {
        return "Mana And Artifice";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopMNAFactionEntryType("");
        }
    }
}

