/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.condition;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;

public class ShopGameStagesCondition
extends AbstractShopEntryCondition {
    public List<String> stages = new ArrayList<String>();

    public ShopGameStagesCondition() {
    }

    protected ShopGameStagesCondition(List<String> stages) {
        this.stages = stages;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isLocked() {
        for (String gameStage : this.stages) {
            if (gameStage.isEmpty() || GameStageHelper.hasStage((Player)Minecraft.m_91087_().f_91074_, (String)gameStage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractShopEntryCondition copy() {
        return new ShopGameStagesCondition(this.stages);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addList("gameStages", this.stages, (ConfigValue)new StringConfig(null), (Object)"");
    }

    @Override
    public String getModId() {
        return "gamestages";
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        ListTag d1 = new ListTag();
        for (String gameStage : this.stages) {
            d1.add((Object)StringTag.m_129297_((String)gameStage));
        }
        nbt.m_128365_("gameStages", (Tag)d1);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("gameStages")) {
            this.stages.clear();
            ListTag d1 = (ListTag)nbt.m_128423_("gameStages");
            for (Tag tag : d1) {
                StringTag f1 = (StringTag)tag;
                this.stages.add(f1.m_7916_());
            }
        }
    }

    @Override
    public String getId() {
        return "gamestagesConditions";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryCondition> {
        @Override
        public AbstractShopEntryCondition createDefaultInstance() {
            return new ShopGameStagesCondition(new ArrayList<String>());
        }
    }
}

