/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.condition.ManaAndArtifice;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;

public class ShopMNATierCondition
extends AbstractShopEntryCondition {
    public int minLevel;
    public int maxLevel;
    public boolean useTierCondition = false;

    public ShopMNATierCondition() {
    }

    public ShopMNATierCondition(int minLevel, int maxLevel, boolean useTierCondition) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.useTierCondition = useTierCondition;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isLocked() {
        if (this.useTierCondition) {
            IPlayerProgression progression = (IPlayerProgression)Minecraft.m_91087_().f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
            boolean any = false;
            if (this.maxLevel == 0) {
                any = true;
            }
            if (any) {
                return progression.getTier() < this.minLevel;
            }
            return progression.getTier() < this.minLevel || progression.getTier() > this.maxLevel;
        }
        return false;
    }

    @Override
    public AbstractShopEntryCondition copy() {
        return new ShopMNATierCondition(this.minLevel, this.maxLevel, this.useTierCondition);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        ConfigGroup group = config.getOrCreateSubgroup("mnatier");
        group.addInt("minLevel", this.minLevel, v -> {
            this.minLevel = v;
        }, 0, 0, 5);
        group.addInt("maxLevel", this.maxLevel, v -> {
            this.maxLevel = v;
        }, 0, 0, 5);
        group.addBool("useTierCondition", this.useTierCondition, v -> {
            this.useTierCondition = v;
        }, false);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        CompoundTag data = new CompoundTag();
        data.m_128405_("minLevel", this.minLevel);
        data.m_128405_("maxLevel", this.maxLevel);
        data.m_128379_("useTierCondition", this.useTierCondition);
        nbt.m_128365_("mnaTier", (Tag)data);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag data = nbt.m_128469_("mnaTier");
        this.minLevel = data.m_128451_("minLevel");
        this.maxLevel = data.m_128451_("maxLevel");
        this.useTierCondition = data.m_128471_("useTierCondition");
    }

    @Override
    public String getModId() {
        return "mna";
    }

    @Override
    public String getId() {
        return "mnaTierCondition";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryCondition> {
        @Override
        public AbstractShopEntryCondition createDefaultInstance() {
            return new ShopMNATierCondition();
        }
    }
}

