/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.condition.ManaAndArtifice;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;

public class ShopMNALevelCondition
extends AbstractShopEntryCondition {
    public int minLevel;
    public int maxLevel;
    public boolean useLevelCondition = false;

    public ShopMNALevelCondition() {
    }

    public ShopMNALevelCondition(int minLevel, int maxLevel, boolean useLevelCondition) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
        this.useLevelCondition = useLevelCondition;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isLocked() {
        if (this.useLevelCondition) {
            IPlayerMagic playerMagic = (IPlayerMagic)Minecraft.m_91087_().f_91074_.getCapability(PlayerMagicProvider.MAGIC).resolve().get();
            boolean anyLevel = false;
            if (this.maxLevel == 0) {
                anyLevel = true;
            }
            if (anyLevel) {
                return playerMagic.getMagicLevel() < this.minLevel;
            }
            return playerMagic.getMagicLevel() < this.minLevel || playerMagic.getMagicLevel() > this.maxLevel;
        }
        return false;
    }

    @Override
    public AbstractShopEntryCondition copy() {
        return new ShopMNALevelCondition(this.minLevel, this.maxLevel, this.useLevelCondition);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        ConfigGroup group = config.getOrCreateSubgroup("mnalevel");
        group.addInt("minLevel", this.minLevel, v -> {
            this.minLevel = v;
        }, 0, 1, 74);
        group.addInt("maxLevel", this.maxLevel, v -> {
            this.maxLevel = v;
        }, 0, 1, 75);
        group.addBool("useLevelCondition", this.useLevelCondition, v -> {
            this.useLevelCondition = v;
        }, false);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        CompoundTag data = new CompoundTag();
        data.m_128405_("minLevel", this.minLevel);
        data.m_128405_("maxLevel", this.maxLevel);
        data.m_128379_("useLevelCondition", this.useLevelCondition);
        nbt.m_128365_("mnaLevel", (Tag)data);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag data = nbt.m_128469_("mnaLevel");
        this.minLevel = data.m_128451_("minLevel");
        this.maxLevel = data.m_128451_("maxLevel");
        this.useLevelCondition = data.m_128471_("useLevelCondition");
    }

    @Override
    public String getModId() {
        return "mna";
    }

    @Override
    public String getId() {
        return "mnaLevelCondition";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryCondition> {
        @Override
        public AbstractShopEntryCondition createDefaultInstance() {
            return new ShopMNALevelCondition();
        }
    }
}

