/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.forge.shop.condition.ManaAndArtifice;

import com.mna.Registries;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;

public class ShopMNAFactionCondition
extends AbstractShopEntryCondition {
    public List<String> factionID = new ArrayList<String>();

    public ShopMNAFactionCondition() {
    }

    protected ShopMNAFactionCondition(List<String> factionID) {
        this.factionID = factionID;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isLocked() {
        Iterator<String> iterator = this.factionID.iterator();
        if (iterator.hasNext()) {
            String s = iterator.next();
            IFaction faction = (IFaction)((IForgeRegistry)Registries.Factions.get()).getValue(new ResourceLocation(s));
            IPlayerProgression progression = (IPlayerProgression)Minecraft.m_91087_().f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).orElse((Object)null);
            if (faction == null) {
                return false;
            }
            return !progression.getAlliedFaction().is(new ResourceLocation(s));
        }
        return false;
    }

    @Override
    public AbstractShopEntryCondition copy() {
        return new ShopMNAFactionCondition(this.factionID);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        config.addList("factionID", this.factionID, (ConfigValue)new StringConfig(null), (Object)"");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        ListTag d1 = new ListTag();
        for (String gameStage : this.factionID) {
            d1.add((Object)StringTag.m_129297_((String)gameStage));
        }
        nbt.m_128365_("factionID", (Tag)d1);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.factionID.clear();
        ListTag d1 = (ListTag)nbt.m_128423_("factionID");
        for (Tag tag : d1) {
            StringTag f1 = (StringTag)tag;
            this.factionID.add(f1.m_7916_());
        }
    }

    @Override
    public String getModId() {
        return "mna";
    }

    @Override
    public String getId() {
        return "mnaFactionCondition";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryCondition> {
        @Override
        public AbstractShopEntryCondition createDefaultInstance() {
            return new ShopMNAFactionCondition();
        }
    }
}

