/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.economy;

import com.spawnchunk.auctionhouse.AuctionHouse;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdm_economy.api.CurrencyHelper;
import net.sixik.sdmshoprework.SDMShopRework;
import org.bukkit.OfflinePlayer;

public class EconomyManager {
    public static EconomyModule economy;

    public static void init() {
        SDMShopRework.LOGGER.info("Try to load economy from mods!");
        economy = new EconomyModule(player -> {}, (player, aLong) -> CurrencyHelper.setMoney((Player)player, (String)"basic_money", (long)aLong), player -> CurrencyHelper.getMoney((Player)player, (String)"basic_money"));
    }

    private static void initPlugins() {
        try {
            Class.forName("org.bukkit.Bukkit");
            Class.forName("dev.architectury.event.forge.EventHandlerImplCommon");
            Class.forName("org.bukkit.OfflinePlayer");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            economy = new EconomyModule(player -> {
                try {
                    Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
                    Object bukkitInstance = bukkitClass.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
                    Optional<Object> optional = Arrays.stream((Object[])bukkitInstance).filter(s -> {
                        try {
                            return s.getClass().getMethod("getUniqueId", new Class[0]).invoke(s, new Object[0]).equals(player.m_20148_());
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }).findFirst();
                    if (optional.isPresent()) {
                        Class<?> economyClass = Class.forName("net.milkbowl.vault.economy.Economy");
                        Method getBalance = economyClass.getMethod("getBalance", OfflinePlayer.class);
                        long balance = Double.doubleToLongBits((Double)getBalance.invoke(optional.get(), new Object[0]));
                        CurrencyHelper.setMoney((Player)player, (String)"basic_money", (long)balance);
                    }
                }
                catch (Exception e) {
                    SDMShopRework.LOGGER.warn("Failed to handle economy: " + e.getMessage());
                }
            }, (player, money) -> {
                try {
                    Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
                    Object bukkitInstance = bukkitClass.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
                    Optional<Object> optional = Arrays.stream((Object[])bukkitInstance).filter(s -> {
                        try {
                            return s.getClass().getMethod("getUniqueId", new Class[0]).invoke(s, new Object[0]).equals(player.m_20148_());
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }).findFirst();
                    if (optional.isPresent()) {
                        Object bukkitPlayer = optional.get();
                        Class<?> economyClass = Class.forName("net.milkbowl.vault.economy.Economy");
                        Method depositPlayer = economyClass.getMethod("depositPlayer", OfflinePlayer.class, Double.TYPE);
                        depositPlayer.invoke((Object)AuctionHouse.econ, bukkitPlayer, Double.longBitsToDouble(money));
                        EconomyManager.economy.sync.accept((Player)player);
                    }
                }
                catch (Exception e) {
                    SDMShopRework.LOGGER.warn("Failed to handle set: " + e.getMessage());
                }
            }, player -> {
                try {
                    Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
                    Object bukkitInstance = bukkitClass.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
                    Optional<Object> optional = Arrays.stream((Object[])bukkitInstance).filter(s -> {
                        try {
                            return s.getClass().getMethod("getUniqueId", new Class[0]).invoke(s, new Object[0]).equals(player.m_20148_());
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }).findFirst();
                    if (optional.isPresent()) {
                        Object bukkitPlayer = optional.get();
                        Class<?> economyClass = Class.forName("net.milkbowl.vault.economy.Economy");
                        Method getBalance = economyClass.getMethod("getBalance", OfflinePlayer.class);
                        return Double.doubleToLongBits((Double)getBalance.invoke((Object)AuctionHouse.econ, bukkitPlayer));
                    }
                }
                catch (Exception e) {
                    SDMShopRework.LOGGER.warn("Failed to handle get: " + e.getMessage());
                }
                return 0L;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public record EconomyModule(Consumer<Player> sync, BiConsumer<Player, Long> set, Function<Player, Long> get) {
    }
}

