/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.type;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopXPLevelEntryType
extends AbstractShopEntryType {
    public int xpLevel;
    public ItemStack iconPath = Items.f_42612_.m_7968_();

    public ShopXPLevelEntryType(int xpLevel) {
        this.xpLevel = xpLevel;
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_9174_(player.f_36078_ - this.xpLevel * countSell);
            entry.shopSellerType.buy(player, entry, entry.entryPrice * (long)countSell);
        }
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            long needMoney = entry.entryPrice * (long)countBuy;
            serverPlayer.m_9174_(player.f_36078_ + this.xpLevel * countBuy);
            entry.shopSellerType.buy(player, entry, -needMoney);
        }
    }

    @Override
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        if (isSell) {
            return player.f_36078_ > countSell * this.xpLevel;
        }
        long playerMoney = entry.shopSellerType.getCount(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (isSell) {
            if (player.f_36079_ == 0 || this.xpLevel == 0) {
                return 0;
            }
            return player.f_36078_ / this.xpLevel;
        }
        long playerMoney = entry.shopSellerType.getCount(player);
        if (entry.entryPrice == 0L) {
            return 127;
        }
        return (int)(playerMoney / entry.entryPrice);
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        ItemStack icon = this.iconPath.m_41777_();
        icon.m_41764_(this.shopEntry.entryCount);
        return ItemIcon.getItemIcon((ItemStack)icon);
    }

    @Override
    public void getConfig(ConfigGroup configGroup) {
        configGroup.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
        configGroup.addInt("level", this.xpLevel, v -> {
            this.xpLevel = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @Override
    public Icon getCreativeIcon() {
        return ItemIcon.getItemIcon((Item)Items.f_42612_);
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopXPLevelEntryType(this.xpLevel);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.xpleveltype");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128405_("level", this.xpLevel);
        NBTUtils.putItemStack(nbt, "iconPath", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.xpLevel = nbt.m_128451_("level");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPath");
    }

    @Override
    public String getId() {
        return "xpLevelType";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopXPLevelEntryType(0);
        }
    }
}

