/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.type;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.utils.StructureUtil;

public class ShopLocateBetaEntryType
extends AbstractShopEntryType {
    public ResourceLocation location;
    public Type type;

    public ShopLocateBetaEntryType(ResourceLocation location, Type type) {
        this.location = location;
        this.type = type;
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            try {
                switch (this.type) {
                    case STRUCTURE: {
                        this.locateStructure(serverPlayer);
                        break;
                    }
                    case BIOME: {
                        this.locateBiome(serverPlayer);
                    }
                }
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        long playerMoney = entry.shopSellerType.getCount(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    public AbstractShopEntryType.SellType getSellType() {
        return AbstractShopEntryType.SellType.ONLY_BUY;
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public Icon getIcon() {
        return Icons.ART;
    }

    private void locateBiome(ServerPlayer player) {
        ResourceKey resourceKey = null;
        Registry registry = player.m_9236_().m_9598_().m_175515_(Registries.f_256952_);
        for (Map.Entry entry : registry.m_6579_()) {
            if (!registry.m_7981_((Object)((Biome)entry.getValue())).toString().equals(this.location.toString())) continue;
            resourceKey = (ResourceKey)entry.getKey();
        }
        if (resourceKey == null || registry.m_203636_(resourceKey).isEmpty()) {
            return;
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)player.m_20182_());
        Holder featureHolderSet = registry.m_203636_(resourceKey).map(Holder::m_205709_).orElse(null);
        Predicate<Holder> b = v -> v == featureHolderSet.m_203334_();
        Pair pair = ((ServerLevel)player.m_9236_()).m_215069_(b, blockpos, 6400, 32, 64);
        if (pair == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Biome not founded ! Are you exactly in the dimension where she might be?"));
        } else {
            String f = "x = " + ((BlockPos)pair.getFirst()).m_123341_() + ",  z = " + ((BlockPos)pair.getFirst()).m_123343_();
            player.m_213846_((Component)Component.m_237113_((String)("The biome is located at the following coordinates " + f)));
        }
    }

    private void locateStructure(ServerPlayer player) throws CommandSyntaxException {
        HolderSet featureHolderSet;
        ResourceKey resourceKey = null;
        Registry registry = player.m_9236_().m_9598_().m_175515_(Registries.f_256944_);
        for (Map.Entry resourceKeyStructureEntry : registry.m_6579_()) {
            if (!registry.m_7981_((Object)((Structure)resourceKeyStructureEntry.getValue())).toString().equals(this.location.toString())) continue;
            resourceKey = (ResourceKey)resourceKeyStructureEntry.getKey();
            break;
        }
        if (resourceKey == null) {
            return;
        }
        if (registry.m_203636_(resourceKey).isEmpty()) {
            return;
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)player.m_20182_());
        ServerLevel serverlevel = (ServerLevel)player.m_9236_();
        Pair<BlockPos, Holder<Structure>> pair = StructureUtil.findNearestMapStructure(serverlevel, (HolderSet<Structure>)(featureHolderSet = (HolderSet)registry.m_203636_(resourceKey).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})).orElse(null)), blockpos, 100, false);
        if (pair == null) {
            player.m_213846_((Component)Component.m_237113_((String)"Structure not founded ! Are you exactly in the dimension where she might be?"));
        } else {
            String f = "x = " + ((BlockPos)pair.getFirst()).m_123341_() + ", y = ?,  z = " + ((BlockPos)pair.getFirst()).m_123343_();
            player.m_213846_((Component)Component.m_237113_((String)("The structure is located at the following coordinates " + f)));
        }
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.addString("locate_id", this.location.toString(), v -> {
            this.location = new ResourceLocation(v);
        }, "minecraft:iglooe");
        group.addEnum("locate_type", (Object)this.type.toString(), v -> {
            this.type = Type.valueOf(v);
        }, this.getIDs());
    }

    public NameMap<String> getIDs() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Type value : Type.values()) {
            ids.add(value.name());
        }
        return NameMap.of((Object)Type.BIOME.name(), ids).create();
    }

    @Override
    public Icon getCreativeIcon() {
        return Icons.ART;
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopLocateBetaEntryType(this.location, this.type);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.locationtype");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128359_("locate_id", this.location.toString());
        nbt.m_128359_("locate_type", this.type.name());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.location = new ResourceLocation(nbt.m_128461_("locate_id"));
        this.type = Type.valueOf(nbt.m_128461_("locate_type"));
    }

    @Override
    public String getId() {
        return "locateType";
    }

    public static enum Type {
        BIOME,
        STRUCTURE;

    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopLocateBetaEntryType(new ResourceLocation("minecraft:iglooe"), Type.BIOME);
        }
    }
}

