/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.type;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopCommandEntryType
extends AbstractShopEntryType {
    private ItemStack iconPath = Items.f_42127_.m_7968_();
    public String command = "";
    public boolean elevatePerms;
    public boolean silent;

    public ShopCommandEntryType(String command, ItemStack iconPath) {
        this.command = command;
        this.iconPath = iconPath;
    }

    public static ShopCommandEntryType of(String command, ItemStack iconPath) {
        return new ShopCommandEntryType(command, iconPath);
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
        group.addString("command", this.command, v -> {
            this.command = v;
        }, "/time set day", Pattern.compile("^/.*"));
        group.addBool("elevatePerms", this.elevatePerms, v -> {
            this.elevatePerms = v;
        }, false);
        group.addBool("silent", this.silent, v -> {
            this.silent = v;
        }, false);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.command");
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopCommandEntryType(this.command, this.iconPath);
    }

    @Override
    public AbstractShopEntryType.SellType getSellType() {
        return AbstractShopEntryType.SellType.ONLY_BUY;
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        nbt.m_128359_("command", this.command);
        if (this.elevatePerms) {
            nbt.m_128379_("elevatePerms", true);
        }
        if (this.silent) {
            nbt.m_128379_("silent", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.iconPath = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("iconPathNew"));
        this.command = nbt.m_128461_("command");
        if (nbt.m_128441_("elevatePerms")) {
            this.elevatePerms = nbt.m_128471_("elevatePerms");
        }
        if (nbt.m_128441_("silent")) {
            this.silent = nbt.m_128471_("silent");
        }
    }

    @Override
    public String getId() {
        return "commandType";
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.command.isEmpty()) {
                return;
            }
            if (this.command.contains("{player}")) {
                this.command = this.command.replace("{player}", serverPlayer.m_7755_().getString());
            }
            CommandSourceStack source = serverPlayer.m_20203_();
            if (this.elevatePerms) {
                source = source.m_81325_(2);
            }
            if (this.silent) {
                source = source.m_81324_();
            }
            try {
                player.m_20194_().m_129892_().m_230957_(source, this.command);
                entry.shopSellerType.buy(player, entry, entry.entryPrice * (long)countBuy);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        long playerMoney = entry.shopSellerType.getCount(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        long playerMoney = entry.shopSellerType.getCount(player);
        if (entry.entryPrice == 0L) {
            return 1;
        }
        return (int)(playerMoney / entry.entryPrice) >= 1 ? 1 : 0;
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopCommandEntryType("", ItemStack.f_41583_);
        }
    }
}

