/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.sellerType;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopSellerType;
import net.sixik.sdmshoprework.common.utils.NBTUtils;
import net.sixik.sdmshoprework.common.utils.SDMItemHelper;
import net.sixik.sdmshoprework.common.utils.item.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class ItemSellerType
extends AbstractShopSellerType<ItemStack> {
    protected boolean showTooltip = false;

    public ItemSellerType(ItemStack type) {
        super(type);
    }

    public ItemSellerType(ItemStack type, boolean showTooltip) {
        super(type);
        this.showTooltip = showTooltip;
    }

    @Override
    public String getEnumName() {
        return "ITEM";
    }

    @Override
    public long getCount(Player player) {
        return SDMItemHelper.countItems(player, (ItemStack)this.type);
    }

    @Override
    public boolean buy(Player player, AbstractShopEntry shopEntry, long countSell) {
        if (shopEntry.isSell) {
            try {
                ItemHandlerHelper.giveItemToPlayer(player, ((ItemStack)this.type).m_255036_((int)countSell));
                return true;
            }
            catch (Exception e) {
                SDMShopRework.printStackTrace("Error when buying: ", e);
                return false;
            }
        }
        long itemCount = this.getCount(player);
        if (itemCount >= countSell) {
            ItemStack copy = ((ItemStack)this.type).m_255036_(1);
            return SDMItemHelper.sellItem(player, (int)countSell, copy, !copy.m_41782_());
        }
        return false;
    }

    @Override
    public String getId() {
        return "item";
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        NBTUtils.putItemStack(nbt, "item", (ItemStack)this.type);
        if (this.showTooltip) {
            nbt.m_128379_("showTooltip", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("item")) {
            this.type = NBTUtils.getItemStack(nbt, "item");
        }
        if (nbt.m_128441_("showTooltip")) {
            this.showTooltip = nbt.m_128471_("showTooltip");
        }
    }

    @Override
    public boolean hasConfig() {
        return true;
    }

    @Override
    public void getConfig(ConfigGroup configGroup) {
        configGroup.addItemStack("item", (ItemStack)this.type, v -> {
            this.type = v;
        }, Items.f_42415_.m_7968_(), true, false);
        configGroup.addBool("showTooltip", this.showTooltip, v -> {
            this.showTooltip = v;
        }, false);
    }

    @Override
    public AbstractShopSellerType<ItemStack> copy() {
        return new ItemSellerType((ItemStack)this.type, this.showTooltip);
    }

    @Override
    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int width, int height, long count, @Nullable Widget widget, int additionSize) {
        int size = height - height / 3 + additionSize;
        ItemIcon.getItemIcon((ItemStack)((ItemStack)this.getType())).draw(graphics, x, y - 1, size, size);
        graphics.m_280488_(Minecraft.m_91087_().f_91062_, String.format("%d", count), x + height, y + 1, 0xFFFFFF);
    }

    @Override
    public void addTooltip(TooltipList tooltipList, AbstractShopEntry entry) {
        if (this.showTooltip) {
            ArrayList<MutableComponent> list1 = new ArrayList<MutableComponent>();
            if (entry.isSell) {
                list1.add(Component.m_237115_((String)"sdmr.shop.ehtry.sell.by").m_130940_(ChatFormatting.GOLD));
            } else {
                list1.add(Component.m_237115_((String)"sdmr.shop.ehtry.sell.off").m_130940_(ChatFormatting.GOLD));
            }
            list1.add(Component.m_237113_((String)"\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e"));
            GuiHelper.addStackTooltip((ItemStack)((ItemStack)this.type), list1);
            list1.add(Component.m_237113_((String)"\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e\u203e"));
            list1.forEach(arg_0 -> ((TooltipList)tooltipList).add(arg_0));
        }
    }

    public static class Constructor
    implements IConstructor<AbstractShopSellerType<?>> {
        @Override
        public AbstractShopSellerType<?> createDefaultInstance() {
            return new ItemSellerType(Items.f_42415_.m_7968_());
        }
    }
}

