/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop;

import dev.ftb.mods.ftblibrary.snbt.SNBT;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.sixik.sdmshoprework.SDMShopPaths;
import net.sixik.sdmshoprework.api.INBTSerializable;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.common.serializer.SerializerControl;
import net.sixik.sdmshoprework.common.shop.ShopDataHelper;
import net.sixik.sdmshoprework.common.shop.ShopTab;

public class ShopBase
implements INBTSerializable<CompoundTag> {
    public static final UUID SHOP_UUID = UUID.fromString("85564763-17ad-4523-b0a3-37f887071b69");
    public static ShopBase SERVER;
    public static ShopBase CLIENT;
    public Component shopName = Component.m_237119_();
    public UUID shopUUID;
    private final LinkedList<Runnable> saveTasks = new LinkedList();
    private final LinkedList<Runnable> deserializeTask = new LinkedList();
    private final List<ShopTab> shopTabs = new ArrayList<ShopTab>();

    public ShopBase() {
        this.shopUUID = UUID.randomUUID();
    }

    public ShopBase(UUID uuid) {
        this.shopUUID = uuid;
    }

    public List<ShopTab> getShopTabs() {
        return this.shopTabs;
    }

    public ShopTab createShopTab(CompoundTag nbt, int bits) {
        ShopTab tab = new ShopTab(this);
        tab.deserializeNBT(nbt, bits);
        this.shopTabs.add(tab);
        return tab;
    }

    public ShopTab getShopTab(UUID uuid) {
        for (ShopTab shopTab : this.shopTabs) {
            if (!Objects.equals(shopTab.shopTabUUID, uuid)) continue;
            return shopTab;
        }
        return null;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        SerializerControl.serializeVersion(nbt);
        nbt.m_128362_("shopUUID", this.shopUUID);
        nbt.m_128359_("shopName", this.shopName.getString());
        ListTag tagShopTabs = new ListTag();
        for (ShopTab shopTab : this.shopTabs) {
            tagShopTabs.add((Object)shopTab.serializeNBT());
        }
        nbt.m_128365_("shopTabs", (Tag)tagShopTabs);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        Runnable runnable = () -> {
            this.shopTabs.clear();
            if (nbt.m_128441_("shopName")) {
                this.shopName = Component.m_237113_((String)nbt.m_128461_("shopName"));
            }
            if (nbt.m_128441_("shopUUID")) {
                this.shopUUID = nbt.m_128342_("shopUUID");
            }
            ListTag tagShopTabs = nbt.m_128437_("shopTabs", 10);
            for (int i = 0; i < tagShopTabs.size(); ++i) {
                ShopTab tab = new ShopTab(this);
                tab.deserializeNBT(tagShopTabs.m_128728_(i));
                this.shopTabs.add(tab);
            }
        };
        this.deserializeTask.add(runnable);
        Iterator runnableIterator = this.deserializeTask.iterator();
        if (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
            runnableIterator.remove();
        }
    }

    public void saveShopToFile() {
        Runnable runnable = () -> {
            try {
                SNBT.write((Path)SDMShopPaths.getFile(), (CompoundTag)this.serializeNBT());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        };
        this.saveTasks.add(runnable);
        Iterator runnableIterator = this.saveTasks.iterator();
        while (runnableIterator.hasNext()) {
            ((Runnable)runnableIterator.next()).run();
            runnableIterator.remove();
        }
    }

    public void syncShop(MinecraftServer server) {
        ShopDataHelper.syncShopData(server);
    }

    public void syncShop(ServerPlayer player) {
        ShopDataHelper.syncShopData(player);
    }

    public boolean changeTab(UUID uuid, CompoundTag nbt) {
        ShopTab tab = this.getShopTab(uuid);
        if (tab != null) {
            tab.deserializeNBT(nbt);
            return true;
        }
        return false;
    }

    public boolean deleteTab(UUID uuid) {
        ShopTab tab = this.getShopTab(uuid);
        if (tab != null) {
            return this.shopTabs.remove(tab);
        }
        return false;
    }

    public boolean changeEntry(UUID uuid, CompoundTag nbt) {
        for (ShopTab shopTab : this.shopTabs) {
            Optional<AbstractShopEntry> obj = shopTab.getTabEntry().stream().filter(s -> s.entryUUID.equals(uuid)).findFirst();
            if (!obj.isPresent()) continue;
            obj.get().deserializeNBT(nbt);
            return true;
        }
        return false;
    }

    public boolean deleteEntry(UUID uuid) {
        for (ShopTab shopTab : this.shopTabs) {
            if (!shopTab.getTabEntry().removeIf(s -> s.entryUUID.equals(uuid))) continue;
            return true;
        }
        return false;
    }

    static {
        CLIENT = new ShopBase(SHOP_UUID);
    }
}

