/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.sixik.sdmshoprework.common.shop.ShopBase;

public class MultiShop {
    public static List<UUID> SHOP_UUIDS = new ArrayList<UUID>();
    public static Map<UUID, ShopBase> SHOP_MAP = new HashMap<UUID, ShopBase>();

    public static ShopBase createShop() {
        return MultiShop.createShop(UUID.randomUUID());
    }

    public static ShopBase createShop(UUID uuid) {
        ShopBase shop = new ShopBase(uuid);
        SHOP_UUIDS.removeIf(s -> s.equals(uuid));
        SHOP_UUIDS.add(shop.shopUUID);
        SHOP_MAP.put(shop.shopUUID, shop);
        return shop;
    }

    public static boolean deleteShop(UUID uuid) {
        return SHOP_UUIDS.remove(uuid) && SHOP_MAP.remove(uuid) != null;
    }

    public static Optional<ShopBase> getShop(UUID uuid) {
        return Optional.ofNullable(SHOP_MAP.get(uuid));
    }

    public static List<UUID> getShops() {
        return new ArrayList<UUID>(SHOP_UUIDS);
    }

    public static void openShop(UUID uuid) {
    }
}

