/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.serializer;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class SerializerControl {
    private static final String VERSION = "1.0.0";

    public static void serializeVersion(CompoundTag nbt) {
        nbt.m_128359_("sdmversion", VERSION);
    }

    public static void deserializeVersion(CompoundTag nbt, ShopBase shop) {
        String version = nbt.m_128461_("sdmversion");
        if (!VERSION.equals(version) && version.equals("0.0.1")) {
            ShopBase shopBase = new ShopBase();
            ListTag tabs = (ListTag)nbt.m_128423_("tabs");
            for (Tag tab : tabs) {
                CompoundTag shopTabData = (CompoundTag)tab;
                ShopTab shopTab = new ShopTab(shopBase);
                shopTab.title = Component.m_237115_((String)shopTabData.m_128461_("title"));
                shopTab.icon = NBTUtils.getItemStack(shopTabData, "icon");
                ListTag entries = (ListTag)shopTabData.m_128423_("entries");
                for (Tag entry : entries) {
                    CompoundTag entryData = (CompoundTag)entry;
                    ShopEntry shopEntry = new ShopEntry(shopTab);
                    shopEntry.entryPrice = entryData.m_128451_("price");
                    shopEntry.entryCount = entryData.m_128451_("count");
                    shopEntry.isSell = entryData.m_128471_("isSell");
                    shopEntry.title = entryData.m_128461_("tittle");
                    shopEntry.entryUUID = entryData.m_128342_("entryID");
                    AbstractShopEntryType entryType = AbstractShopEntryType.fromOld(entryData.m_128469_("type"));
                    if (entryType != null) {
                        shopEntry.setEntryType(entryType);
                    }
                    shopTab.getTabEntry().add(shopEntry);
                }
                shopBase.getShopTabs().add(shopTab);
            }
            ShopBase.SERVER.deserializeNBT(shopBase.serializeNBT());
        }
    }

    public static boolean isOldVersion(CompoundTag nbt) {
        if (!nbt.m_128441_("sdmversion")) {
            return true;
        }
        return SerializerControl.isOldVersion(nbt.m_128461_("sdmversion"));
    }

    public static boolean isOldVersion(String version) {
        return !VERSION.equals(version);
    }
}

