/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.integration.KubeJS;

import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;

public interface ShopJS {
    default public void setMoney(Player player, long count) {
        SDMShopR.setMoney(player, count);
    }

    default public void addMoney(Player player, long count) {
        SDMShopR.addMoney(player, count);
    }

    default public long getMoney(Player player) {
        return SDMShopR.getMoney(player);
    }

    default public void buyEntry(Player player, String entryID, int count, boolean takeMoney) {
        UUID uuid = UUID.fromString(entryID);
        for (ShopTab shopTab : ShopBase.SERVER.getShopTabs()) {
            AbstractShopEntry entry = shopTab.getShopEntry(uuid);
            if (entry == null) continue;
            if (entry.isSell) {
                return;
            }
            if (!takeMoney) {
                long money = entry.entryPrice * (long)count;
                this.addMoney(player, money);
            }
            entry.getEntryType().buy(player, count, entry);
            return;
        }
    }

    default public AbstractShopTab getShopTab(String tabID) {
        UUID uuid = UUID.fromString(tabID);
        return ShopBase.SERVER.getShopTab(uuid);
    }

    default public AbstractShopEntry getShopEntry(String entryID) {
        UUID uuid = UUID.fromString(entryID);
        for (ShopTab shopTab : ShopBase.SERVER.getShopTabs()) {
            AbstractShopEntry entry = shopTab.getShopEntry(uuid);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }
}

