/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.integration.FTBQuests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.SDMShopRework;

public class MoneyTask
extends Task
implements ISingleLongValueTask {
    public static TaskType TYPE;
    public long value = 1L;

    public MoneyTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return TYPE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public String formatMaxProgress() {
        return SDMShopRework.moneyString(this.value);
    }

    public String formatProgress(TeamData teamData, long progress) {
        return SDMShopRework.moneyString(progress);
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128356_("value", this.value);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.value = nbt.m_128454_("value");
    }

    public void writeNetData(FriendlyByteBuf buf) {
        super.writeNetData(buf);
        buf.m_130103_(this.value);
    }

    public void readNetData(FriendlyByteBuf buf) {
        super.readNetData(buf);
        this.value = buf.m_130258_();
    }

    public void setValue(long v) {
        this.value = v;
    }

    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setNameKey("ftbquests.task.sdmshop");
    }

    public Component getAltTitle() {
        return Component.m_237113_((String)SDMShopRework.moneyString(this.value));
    }

    public boolean consumesResources() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addMouseOverText(TooltipList list, TeamData teamData) {
        super.addMouseOverText(list, teamData);
        list.add((Component)Component.m_237115_((String)"sdmshop.balance").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)SDMShopRework.moneyString(SDMShopR.getMoney((Player)Minecraft.m_91087_().f_91074_)))).m_130940_(ChatFormatting.GRAY));
    }

    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        long money = SDMShopR.getMoney((Player)player);
        long add = Math.min(money, this.value - teamData.getProgress((Task)this));
        if (add > 0L) {
            SDMShopR.setMoney((Player)player, money - add);
            teamData.addProgress((Task)this, add);
        }
    }
}

