/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.config;

import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import java.nio.file.Path;
import net.sixik.sdmshoprework.SDMShopPaths;
import net.sixik.sdmshoprework.common.config.ConfigFile;
import net.sixik.sdmshoprework.common.theme.SDMThemes;
import net.sixik.sdmshoprework.common.theme.ShopStyle;

public class Config {
    public static final EnumValue<ShopStyle> STYLE;
    public static final EnumValue<SDMThemes> THEMES;
    public static final SNBTConfig CONFIG;
    public static final StringValue BACKGROUND;
    public static final StringValue SHADOW;
    public static final StringValue REACT;
    public static final StringValue STOKE;
    public static final StringValue TEXTCOLOR;
    public static final StringValue SELCETTABCOLOR;
    public static final BooleanValue DISABLE_KEYBIND;
    public static final BooleanValue SEND_NOTIFY;
    public static String defaultBackground;
    public static String defaultShadow;
    public static String defaultReact;
    public static String defaultStoke;
    public static String defaultTextColor;
    public static String colorSelectTab;
    public static final String THEMES_NAME = "Shop Theme";
    public static final String STYLE_NAME = "Shop Style";

    public static void init(Path file) {
        Config.loadConfig(true);
    }

    public static void reload() {
        CONFIG.load(SDMShopPaths.getClientConfig());
    }

    public static void loadConfig(boolean client) {
        ConfigUtil.loadDefaulted((SNBTConfig)CONFIG, (Path)SDMShopPaths.getModFolder(), (String)"sdmshop");
        if (client) {
            ConfigFile.CLIENT.disableKeyBind = (Boolean)DISABLE_KEYBIND.get();
        } else {
            ConfigFile.SERVER.disableKeyBind = (Boolean)DISABLE_KEYBIND.get();
        }
    }

    static {
        defaultBackground = "#5555FF";
        defaultShadow = "#5555FF";
        defaultReact = "#5555FF";
        defaultStoke = "#5555FF";
        defaultTextColor = "#5555FF";
        colorSelectTab = "#5555FF";
        CONFIG = SNBTConfig.create((String)"sdmshop-common");
        DISABLE_KEYBIND = CONFIG.addBoolean("disable_key_bind", false);
        SEND_NOTIFY = CONFIG.addBoolean("send_notify", true);
        STYLE = CONFIG.addEnum(STYLE_NAME, ShopStyle.NAME_MAP);
        THEMES = CONFIG.addEnum(THEMES_NAME, SDMThemes.NAME_MAP);
        SNBTConfig CUSTOM = CONFIG.addGroup("CUSTOM");
        BACKGROUND = CUSTOM.addString("background", defaultBackground);
        SHADOW = CUSTOM.addString("shadow", defaultShadow);
        REACT = CUSTOM.addString("react", defaultReact);
        STOKE = CUSTOM.addString("stoke", defaultStoke);
        TEXTCOLOR = CUSTOM.addString("select_tab_color", defaultTextColor);
        SELCETTABCOLOR = CUSTOM.addString("moneyTextColor", colorSelectTab);
    }
}

