/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdmshoprework.SDMShopPaths;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.common.config.Config;
import net.sixik.sdmshoprework.common.data.LimiterData;
import net.sixik.sdmshoprework.common.shop.MultiShop;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.economy.EconomyManager;
import net.sixik.sdmshoprework.network.client.SendEditModeS2C;
import net.sixik.sdmshoprework.network.client.SendEntryLimitS2C;
import net.sixik.sdmshoprework.network.server.misc.SendConfigS2C;

public class ModEvents {
    public static void init() {
        LifecycleEvent.SERVER_STARTED.register(ModEvents::onServerStart);
        LifecycleEvent.SERVER_STOPPED.register(ModEvents::onServerStopped);
        PlayerEvent.PLAYER_JOIN.register(ModEvents::onPlayerLoggedIn);
    }

    public static void onServerStart(MinecraftServer server) {
        EconomyManager.init();
        Config.loadConfig(false);
        if (SDMShopPaths.getFile().toFile().exists()) {
            SNBTCompoundTag nbt = SNBT.read((Path)SDMShopPaths.getFile());
            if (nbt != null) {
                ShopBase.SERVER = MultiShop.createShop(ShopBase.SHOP_UUID);
                ShopBase.SERVER.deserializeNBT((CompoundTag)nbt);
                ShopBase.SERVER.saveShopToFile();
            } else {
                ShopBase.SERVER = MultiShop.createShop(ShopBase.SHOP_UUID);
            }
        }
        LimiterData.SERVER = new LimiterData();
        LimiterData.SERVER.load(server);
    }

    public static void onServerStopped(MinecraftServer server) {
        if (ShopBase.SERVER != null) {
            ShopBase.SERVER.saveShopToFile();
        }
        if (LimiterData.SERVER != null) {
            LimiterData.SERVER.save(server);
        }
    }

    public static void onPlayerLoggedIn(ServerPlayer player) {
        if (!player.m_7578_() || !player.m_9236_().f_46443_) {
            ShopBase.SERVER.syncShop(player);
            new SendEditModeS2C(SDMShopR.isEditMode((Player)player)).sendTo(player);
            new SendConfigS2C().sendTo(player);
            new SendEntryLimitS2C(LimiterData.SERVER.serializeClient(player.m_36316_().getId())).sendTo(player);
        }
    }
}

