/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.modern.widget;

import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.client.screen.basic.widget.AbstractShopEntryButton;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopScreen;
import net.sixik.sdmshoprework.client.screen.modern.buyer.ModernBuyerScreen;
import net.sixik.sdmuilib.client.utils.GLHelper;
import net.sixik.sdmuilib.client.utils.TextHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.math.Vector2f;
import net.sixik.sdmuilib.client.utils.misc.RGBA;

public class ModernShopEntryButton
extends AbstractShopEntryButton {
    public ModernShopEntryButton(Panel panel, AbstractShopEntry entry) {
        super(panel, entry);
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isSelected()) {
            RGBA.create((int)255, (int)255, (int)255, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        } else {
            RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        }
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        GuiHelper.setupDrawing();
        int s = h >= 16 ? 16 : 8;
        this.drawBackground(graphics, theme, x, y, w, h);
        int size = 0;
        if (this.entry != null) {
            size = 16;
            this.drawIcon(graphics, theme, x + size / 2, y + 2, w - size, h - size);
            RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x + 2, y + w + 2, w - 4, 8, 2);
            Vector2 pos = new Vector2(0, 0);
            int centeredX = 0;
            Vector2f textSize = new Vector2f(0.0f, 0.0f);
            int textWidth = 0;
            MutableComponent component = this.entry.isSell ? Component.m_237115_((String)"sdm.shop.entry.sell") : Component.m_237115_((String)"sdm.shop.entry.buy");
            textSize = TextHelper.getTextRenderSize((String)component.getString(), (int)w, (float)0.7f, (int)50);
            textWidth = (int)TextHelper.getTextWidth((String)component.getString(), (float)textSize.y);
            centeredX = x + 2 + (w - 4 - textWidth) / 2;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            pos = new Vector2(centeredX, y + h - 9 - 1);
            GLHelper.pushTransform((GuiGraphics)graphics, (Vector2)pos, (Vector2)new Vector2(1, 1), (float)textSize.y, (float)0.0f);
            theme.drawString(graphics, (Object)component, pos.x, pos.y);
            GLHelper.popTransform((GuiGraphics)graphics);
            String textMoney = SDMShopRework.moneyString(this.entry.entryPrice);
            textSize = TextHelper.getTextRenderSize((String)textMoney, (int)(w - 4), (float)0.7f, (int)50);
            textWidth = (int)TextHelper.getTextWidth((String)textMoney, (float)textSize.y);
            centeredX = x + 2 + (w - 4 - textWidth) / 2;
            pos = new Vector2(centeredX, y + w + 2 + 1);
            GLHelper.pushTransform((GuiGraphics)graphics, (Vector2)pos, (Vector2)new Vector2(1, 1), (float)textSize.y, (float)0.0f);
            this.entry.shopSellerType.draw(graphics, theme, pos.x, pos.y, w, 16, this.entry.entryPrice, (Widget)this, 0);
            GLHelper.popTransform((GuiGraphics)graphics);
        } else {
            size = this.height / 2;
            this.drawIcon(graphics, theme, x + size / 2, y + size / 2, w - size, h - size);
        }
    }

    @Override
    public void openBuyScreen() {
        new ModernBuyerScreen((ModernShopScreen)this.getShopScreen(), this).openGui();
    }
}

