/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.modern.buyer;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdm_economy.api.CurrencyHelper;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.client.screen.basic.buyer.AbstractBuyerBuyButton;
import net.sixik.sdmshoprework.client.screen.basic.buyer.AbstractBuyerCancelButton;
import net.sixik.sdmshoprework.client.screen.basic.buyer.AbstractBuyerScreen;
import net.sixik.sdmshoprework.client.screen.basic.widget.AbstractShopEntryButton;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopScreen;
import net.sixik.sdmshoprework.common.data.LimiterData;
import net.sixik.sdmshoprework.common.shop.type.ShopItemEntryType;
import net.sixik.sdmuilib.client.utils.GLHelper;
import net.sixik.sdmuilib.client.utils.TextHelper;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.misc.RGBA;
import org.jetbrains.annotations.Nullable;

public class ModernBuyerScreen
extends AbstractBuyerScreen {
    private int limit;
    public TextBox textBox;
    int sizeIcon;
    int howMane;
    public Component entryType;
    public ModernShopScreen screen;
    public AbstractShopEntryButton entryButton;

    public boolean drawDefaultBackground(GuiGraphics graphics) {
        return false;
    }

    public ModernBuyerScreen(ModernShopScreen screen, AbstractShopEntryButton shopEntry) {
        this.screen = screen;
        this.entryButton = shopEntry;
        this.shopEntry = shopEntry.entry;
        int tabLimit = LimiterData.CLIENT.TAB_DATA.getOrDefault(shopEntry.entry.getShopTab().shopTabUUID, 0);
        int entryLimit = LimiterData.CLIENT.ENTRY_DATA.getOrDefault(shopEntry.entry.entryUUID, 0);
        int max = tabLimit == 0 ? entryLimit : Math.min(tabLimit, entryLimit > 0 ? entryLimit : tabLimit);
        if (shopEntry.entry.getShopTab().limit != 0) {
            max = shopEntry.entry.getShopTab().limit - max;
        } else if (shopEntry.entry.limit != 0) {
            max = shopEntry.entry.limit - max;
        }
        this.limit = Math.max(max, 0);
    }

    public void addWidgets() {
        this.textBox = new TextBox((Panel)this){

            public boolean isValid(String txt) {
                return ModernBuyerScreen.this.parse(null, txt, 1, ModernBuyerScreen.this.howMane);
            }

            public void onTextChanged() {
                if (!this.getText().isEmpty()) {
                    ModernBuyerScreen.this.count = Integer.parseInt(this.getText());
                }
            }

            public void drawTextBox(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                RGBA.create((int)0, (int)0, (int)0, (int)127).drawRoundFill(graphics, x, y, w, h, 4);
            }
        };
        this.add((Widget)this.textBox);
        this.cancelButton = new CancelButton(this);
        this.add((Widget)this.cancelButton);
        this.buyButton = new BuyButton(this);
        this.add((Widget)this.buyButton);
        this.setProperty();
    }

    public void alignWidgets() {
        this.setProperty();
    }

    @Override
    public void setProperty() {
        int bsize = this.width / 2 - 10;
        this.sizeIcon = this.width >= 16 ? 16 : 8;
        this.cancelButton.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buyButton.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
        this.textBox.setText(this.count > 0 ? String.valueOf(this.count) : "");
        this.textBox.ghostText = this.shopEntry.isSell ? Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.input.ghost.sell").getString() : Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.input.ghost.buy").getString();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.textBox.setPos(5, 5 + this.sizeIcon * 2 + 2 + (9 + 1 + 2) * 2);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.textBox.setSize(this.width - 10, 9 + 1);
        this.updateButtons();
    }

    public void updateButtons() {
        this.howMane = this.shopEntry.getEntryType().howMany((Player)Minecraft.m_91087_().f_91074_, this.shopEntry.isSell, this.shopEntry);
        if (this.entryButton.entry.limit != 0) {
            this.howMane = Math.min(this.limit, this.howMane);
        }
        this.entryType = this.shopEntry.isSell ? Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.sell") : Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.buy");
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        RGBA.create((int)0, (int)0, (int)0, (int)127).drawRoundFill(graphics, x, y, w, h, 10);
        Vector2 pos = new Vector2(x + 5, y + 5);
        RGBA.create((int)0, (int)0, (int)0, (int)127).drawRoundFill(graphics, pos.x, pos.y, this.sizeIcon * 2, this.sizeIcon * 2, 8);
        this.entryButton.entry.getEntryType().getIcon().draw(graphics, pos.x + this.sizeIcon / 2, pos.y + this.sizeIcon / 2, this.sizeIcon, this.sizeIcon);
        pos.setX(pos.x + this.sizeIcon * 2 + 2);
        RGBA rGBA = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n = pos.x;
        int n2 = pos.y;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA.drawRoundFill(graphics, n, n2, this.width - 10 - 2 - this.sizeIcon * 2, 9 + 1, 4);
        AbstractShopEntryType abstractShopEntryType = this.entryButton.entry.getEntryType();
        if (abstractShopEntryType instanceof ShopItemEntryType) {
            ShopItemEntryType entryType = (ShopItemEntryType)abstractShopEntryType;
            w = TextHelper.getTextWidth((String)entryType.itemStack.m_41611_().getString());
            int w1 = this.width - 10 - 2 - this.sizeIcon * 2 - w;
            w2 = w1 / 2;
            d = entryType.itemStack.m_41611_().getString();
            d = d.replace("[", "").replace("]", "");
            theme.drawString(graphics, (Object)d, pos.x + w2, pos.y + 1, Color4I.WHITE, 2);
        } else if (!this.entryButton.entry.title.isEmpty()) {
            w = TextHelper.getTextWidth((String)this.entryButton.entry.title);
            int w1 = this.width - 10 - 2 - this.sizeIcon * 2 - w;
            w2 = w1 / 2;
            d = this.entryButton.entry.title;
            theme.drawString(graphics, (Object)d, pos.x + w2, pos.y + 1, Color4I.WHITE, 2);
        }
        String textMoney = SDMShopRework.moneyString(this.entryButton.entry.entryPrice);
        int d = TextHelper.getTextWidth((String)textMoney);
        int w1 = this.width - 10 - 2 - this.sizeIcon * 2 - d;
        int w2 = w1 / 2;
        pos.setY(pos.y + this.sizeIcon);
        RGBA rGBA2 = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n3 = pos.x;
        int n4 = pos.y;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA2.drawRoundFill(graphics, n3, n4, this.width - 10 - 2 - this.sizeIcon * 2, 9 + 1, 4);
        this.shopEntry.shopSellerType.draw(graphics, theme, pos.x + w2, pos.y + 1, w, 16, this.entryButton.entry.entryPrice, (Widget)this, -2);
        pos.setPosition(x + 5, y + 5 + this.sizeIcon * 2 + 2);
        Vector2 size = new Vector2(this.width - 10, this.height - (5 + this.sizeIcon * 2 + 2 + 24 + 2));
        RGBA rGBA3 = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n5 = pos.x;
        int n6 = pos.y;
        int n7 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA3.drawRoundFill(graphics, n5, n6, n7, 9 + 1, 4);
        int n8 = pos.x;
        int n9 = pos.y;
        int n10 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GLHelper.pushScissor((GuiGraphics)graphics, (int)n8, (int)n9, (int)n10, (int)(9 + 1));
        theme.drawString(graphics, (Object)Component.m_237115_((String)"sdm.shop.modern.ui.buyer.player_money"), pos.x + 2, pos.y + 1, Color4I.WHITE, 2);
        GLHelper.popScissor((GuiGraphics)graphics);
        RGBA rGBA4 = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n11 = pos.x + size.x / 2;
        int n12 = pos.y;
        int n13 = size.x / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA4.drawRoundFill(graphics, n11, n12, n13, 9 + 1, 4);
        textMoney = SDMShopRework.moneyString(CurrencyHelper.Basic.getMoney((Player)Minecraft.m_91087_().f_91074_));
        int n14 = pos.x + size.x / 2;
        int n15 = pos.y;
        int n16 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GLHelper.pushScissor((GuiGraphics)graphics, (int)n14, (int)n15, (int)n16, (int)(9 + 1));
        this.shopEntry.shopSellerType.draw(graphics, theme, pos.x + size.x / 2 + 2, pos.y + 1, w, 16, this.shopEntry.shopSellerType.getCount((Player)Minecraft.m_91087_().f_91074_), (Widget)this, -2);
        GLHelper.popScissor((GuiGraphics)graphics);
        int n17 = pos.x;
        int n18 = pos.y;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        pos.setPosition(n17, n18 + 9 + 1 + 2);
        this.drawNewLabel(graphics, theme, pos, size, this.entryType.getString(), String.valueOf(this.howMane));
        if (this.limit != 0) {
            int n19 = pos.x;
            int n20 = pos.y;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            pos.setPosition(n19, n20 + (9 + 1 + 2) * 2);
            this.drawNewLabel(graphics, theme, pos, size, Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.limit").getString(), String.valueOf(this.limit));
            int n21 = pos.x;
            int n22 = pos.y;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            pos.setPosition(n21, n22 + 9 + 1 + 2);
            textMoney = this.shopEntry.isSell ? Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.output.sell").getString() : Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.output.buy").getString();
        } else {
            int n23 = pos.x;
            int n24 = pos.y;
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            pos.setPosition(n23, n24 + (9 + 1 + 2) * 2);
            textMoney = this.shopEntry.isSell ? Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.output.sell").getString() : Component.m_237115_((String)"sdm.shop.modern.ui.buyer.entry.output.buy").getString();
        }
        this.drawNewLabelR(graphics, theme, pos, size, textMoney, SDMShopRework.moneyString(this.shopEntry.entryPrice * (long)this.count));
    }

    public void drawNewLabel(GuiGraphics graphics, Theme theme, Vector2 pos, Vector2 size, String left, String right) {
        RGBA rGBA = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n = pos.x;
        int n2 = pos.y;
        int n3 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA.drawRoundFill(graphics, n, n2, n3, 9 + 1, 4);
        int n4 = pos.x;
        int n5 = pos.y;
        int n6 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GLHelper.pushScissor((GuiGraphics)graphics, (int)n4, (int)n5, (int)n6, (int)(9 + 1));
        theme.drawString(graphics, (Object)left, pos.x + 2, pos.y + 1, Color4I.WHITE, 2);
        GLHelper.popScissor((GuiGraphics)graphics);
        RGBA rGBA2 = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n7 = pos.x + size.x / 2;
        int n8 = pos.y;
        int n9 = size.x / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA2.drawRoundFill(graphics, n7, n8, n9, 9 + 1, 4);
        int n10 = pos.x + size.x / 2;
        int n11 = pos.y;
        int n12 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GLHelper.pushScissor((GuiGraphics)graphics, (int)n10, (int)n11, (int)n12, (int)(9 + 1));
        theme.drawString(graphics, (Object)right, pos.x + size.x / 2 + 2, pos.y + 1, Color4I.WHITE, 2);
        GLHelper.popScissor((GuiGraphics)graphics);
    }

    public void drawNewLabelR(GuiGraphics graphics, Theme theme, Vector2 pos, Vector2 size, String left, String right) {
        RGBA rGBA = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n = pos.x;
        int n2 = pos.y;
        int n3 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA.drawRoundFill(graphics, n, n2, n3, 9 + 1, 4);
        int n4 = pos.x;
        int n5 = pos.y;
        int n6 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GLHelper.pushScissor((GuiGraphics)graphics, (int)n4, (int)n5, (int)n6, (int)(9 + 1));
        theme.drawString(graphics, (Object)left, pos.x + 2, pos.y + 1, Color4I.WHITE, 2);
        GLHelper.popScissor((GuiGraphics)graphics);
        RGBA rGBA2 = RGBA.create((int)0, (int)0, (int)0, (int)127);
        int n7 = pos.x + size.x / 2;
        int n8 = pos.y;
        int n9 = size.x / 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        rGBA2.drawRoundFill(graphics, n7, n8, n9, 9 + 1, 4);
        int n10 = pos.x + size.x / 2;
        int n11 = pos.y;
        int n12 = size.x / 2 - 2;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        GLHelper.pushScissor((GuiGraphics)graphics, (int)n10, (int)n11, (int)n12, (int)(9 + 1));
        this.shopEntry.shopSellerType.draw(graphics, theme, pos.x + size.x / 2 + 2, pos.y + 1, 0, 16, this.shopEntry.entryPrice * (long)this.count, (Widget)this, -2);
        GLHelper.popScissor((GuiGraphics)graphics);
    }

    public boolean parse(@Nullable Consumer<Integer> callback, String string, int min, int max) {
        try {
            int v = Long.decode(string).intValue();
            if (v >= Integer.valueOf(min) && v <= Integer.valueOf(max)) {
                if (callback != null) {
                    callback.accept(v);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static class CancelButton
    extends AbstractBuyerCancelButton {
        public CancelButton(ModernBuyerScreen modernBuyerScreen) {
            super((Panel)modernBuyerScreen);
        }

        public boolean renderTitleInCenter() {
            return true;
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            RGBA.create((int)0, (int)0, (int)0, (int)127).drawRoundFill(graphics, x, y, w, h, 6);
        }
    }

    public static class BuyButton
    extends AbstractBuyerBuyButton {
        public BuyButton(ModernBuyerScreen modernBuyerScreen) {
            super((Panel)modernBuyerScreen);
        }

        public boolean renderTitleInCenter() {
            return true;
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            RGBA.create((int)0, (int)0, (int)0, (int)127).drawRoundFill(graphics, x, y, w, h, 6);
        }
    }
}

