/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.modern;

import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmshoprework.SDMShopClient;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.client.screen.basic.AbstractShopScreen;
import net.sixik.sdmshoprework.client.screen.basic.widget.AbstractShopEntryButton;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopEntriesPanel;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopPanels;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopTabPanel;
import net.sixik.sdmshoprework.client.screen.modern.widget.ModernMarketButton;
import net.sixik.sdmshoprework.client.screen.modern.widget.ModernShopEntryButton;
import net.sixik.sdmshoprework.client.screen.modern.widget.ModernShopTabButton;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmuilib.client.utils.math.Vector2;
import net.sixik.sdmuilib.client.utils.misc.RGBA;

public class ModernShopScreen
extends AbstractShopScreen {
    public PanelScrollBar tabsScrollPanel;
    public PanelScrollBar entryScrollPanel;
    public ModernShopPanels.TopEntriesPanel topEntriesPanel;
    public ModernShopPanels.TopPanel topPanel;
    public ModernShopPanels.BottomPanel bottomPanel;
    public ModernMarketButton marketButton;
    public Vector2 entryButtonSize = new Vector2(38, 38);

    public ModernShopScreen(boolean isOpenCommand) {
        super(isOpenCommand);
    }

    public void addWidgets() {
        if (SDMShopR.isMarketLoaded) {
            this.marketButton = new ModernMarketButton((Panel)this);
            this.add((Widget)this.marketButton);
        }
        this.tabsPanel = new ModernShopTabPanel((Panel)this);
        this.add((Widget)this.tabsPanel);
        this.tabsScrollPanel = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.tabsPanel){

            public void drawScrollBar(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getReact().draw(graphics, x, y, w, h);
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                RGBA.create((int)0, (int)0, (int)0, (int)127).draw(graphics, x, y, w, h, 0.0f);
            }
        };
        this.add((Widget)this.tabsScrollPanel);
        this.bottomPanel = new ModernShopPanels.BottomPanel((Panel)this);
        this.add((Widget)this.bottomPanel);
        this.topPanel = new ModernShopPanels.TopPanel((Panel)this);
        this.add((Widget)this.topPanel);
        this.entriesPanel = new ModernShopEntriesPanel((Panel)this);
        this.add((Widget)this.entriesPanel);
        this.entryScrollPanel = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.entriesPanel){

            public void drawScrollBar(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getReact().draw(graphics, x, y, w, h);
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                RGBA.create((int)0, (int)0, (int)0, (int)127).draw(graphics, x, y, w, h, 0.0f);
            }
        };
        this.add((Widget)this.entryScrollPanel);
        this.topEntriesPanel = new ModernShopPanels.TopEntriesPanel((Panel)this);
        this.add((Widget)this.topEntriesPanel);
        this.setProperties();
    }

    @Override
    public void setProperties() {
        if (this.marketButton != null) {
            this.marketButton.setPos(this.width + 2, 0);
        }
        this.tabsPanel.setY(this.height / 7);
        this.tabsPanel.setSize(this.width / 5, this.height - this.height / 7 * 2);
        this.topPanel.setPos(0, 0);
        this.topPanel.setSize(this.tabsPanel.width, this.height / 7 - 2);
        this.bottomPanel.setPos(0, this.tabsPanel.getPosY() + 2 + this.tabsPanel.height);
        this.bottomPanel.setSize(this.tabsPanel.width, this.height / 7 - 2);
        this.entriesPanel.setPos(this.tabsPanel.width + 2, this.tabsPanel.posY);
        this.entriesPanel.setSize(this.width - this.tabsPanel.width - 2, this.height - this.topPanel.height - 2);
        this.topEntriesPanel.setPos(this.tabsPanel.width + 2, 0);
        this.topEntriesPanel.setSize(this.width - this.tabsPanel.width - 2, this.topPanel.height);
        this.tabsScrollPanel.setPosAndSize(this.tabsPanel.getPosX() + this.tabsPanel.getWidth() - this.getScrollbarWidth(), this.tabsPanel.getPosY(), this.getScrollbarWidth(), this.tabsPanel.getHeight());
        this.entryScrollPanel.setPosAndSize(this.entriesPanel.getPosX() + this.entriesPanel.getWidth() - this.getScrollbarWidth(), this.entriesPanel.getPosY(), this.getScrollbarWidth(), this.entriesPanel.getHeight() - 10);
        this.addTabsButtons();
        this.addEntriesButtons();
    }

    @Override
    public void addEntriesButtons() {
        if (this.selectedTab != null) {
            ArrayList<AbstractShopEntryButton> widgets = new ArrayList<AbstractShopEntryButton>();
            for (AbstractShopEntry abstractShopEntry : this.selectedTab.getTabEntry()) {
                if (abstractShopEntry.isLocked() && !SDMShopR.isEditMode() || !this.searchField.isEmpty() && !abstractShopEntry.getEntryType().isSearch(this.searchField)) continue;
                ModernShopEntryButton button = new ModernShopEntryButton(this.entriesPanel, abstractShopEntry);
                button.setSize(this.entryButtonSize.x, this.entryButtonSize.y);
                widgets.add(button);
            }
            if (SDMShopR.isEditMode()) {
                ModernShopEntryButton button = new ModernShopEntryButton(this.entriesPanel, null);
                button.setSize(this.entryButtonSize.x, this.entryButtonSize.y);
                button.setEdit();
                widgets.add(button);
            }
            this.calculatePositions(widgets);
            this.entriesPanel.getWidgets().clear();
            this.entriesPanel.addAll(widgets);
            this.entryScrollPanel.setValue(this.entryScrollPos);
        }
    }

    @Override
    public void calculatePositions(List<AbstractShopEntryButton> entryButtons) {
        int maxElementsOnScreen = this.getCountInArray() - 1;
        int x = this.getStartPosX(maxElementsOnScreen);
        int y = 2;
        for (int i = 0; i < entryButtons.size(); ++i) {
            AbstractShopEntryButton shopEntryButton = entryButtons.get(i);
            if (i > 0) {
                if (i % maxElementsOnScreen == 0) {
                    y += this.entryButtonSize.y + 6 + 8;
                    x = this.getStartPosX(maxElementsOnScreen);
                } else {
                    x += this.entryButtonSize.x + 3;
                }
                shopEntryButton.setPos(x, y);
                continue;
            }
            shopEntryButton.setPos(x, y);
        }
        ModernShopEntryButton d1 = new ModernShopEntryButton(this.entriesPanel, null){

            @Override
            public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            }

            public boolean checkMouseOver(int mouseX, int mouseY) {
                return false;
            }
        };
        d1.setPos(0, y + 40);
        entryButtons.add(d1);
    }

    public int getCountInArray() {
        int x1 = 0;
        int x = this.entryButtonSize.x;
        for (int i = 0; i < 1000; ++i) {
            x1 = x * i + 3 * i;
            if (x1 <= this.entriesPanel.width) continue;
            return i - 1;
        }
        return 0;
    }

    public int getStartPosX(int count) {
        int x = this.entryButtonSize.x;
        int x1 = 0;
        for (int i = 0; i < count + 1; ++i) {
            x1 = x * i + 3 * i;
        }
        return this.entriesPanel.width / 2 - x1 / 2;
    }

    @Override
    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
    }

    @Override
    public void addTabsButtons() {
        ArrayList<ModernShopTabButton> widgetList = new ArrayList<ModernShopTabButton>();
        int y = 0;
        for (ShopTab shopTab : ShopBase.CLIENT.getShopTabs()) {
            if (shopTab.isLocked() && !SDMShopR.isEditMode()) continue;
            ModernShopTabButton button = new ModernShopTabButton(this.tabsPanel, shopTab);
            button.setSize(this.tabsPanel.width - 2 - this.getScrollbarWidth(), 15);
            button.setPos(0, y);
            widgetList.add(button);
            y += button.height + 3;
        }
        if (SDMShopR.isEditMode()) {
            ModernShopTabButton button = new ModernShopTabButton(this.tabsPanel, null);
            button.setSize(this.tabsPanel.width - 2 - this.getScrollbarWidth(), 15);
            button.setPos(0, y);
            button.setEdit();
            widgetList.add(button);
        }
        this.tabsPanel.getWidgets().clear();
        this.tabsPanel.addAll(widgetList);
        this.tabsScrollPanel.setValue(0.0);
    }

    protected int getScrollbarWidth() {
        return 2;
    }

    @Override
    public void setSelectedTab(AbstractShopTab shopTab) {
        if (this.selectedTab == null) {
            this.addEntriesButtons();
            return;
        }
        this.entryScrollPos = this.selectedTab.shopTabUUID.equals(shopTab.shopTabUUID) ? Math.min(this.entryScrollPanel.getValue(), this.entryScrollPanel.getMaxValue()) : 0.0;
        super.setSelectedTab(shopTab);
    }
}

