/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.basic.widget;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.client.screen.basic.AbstractShopScreen;
import net.sixik.sdmshoprework.client.screen.legacy.buyer.LegacyBuyerScreen;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.common.shop.type.ShopItemEntryType;
import net.sixik.sdmshoprework.common.utils.ListHelper;
import net.sixik.sdmshoprework.common.utils.TypeCreator;
import net.sixik.sdmshoprework.network.server.SendChangesShopEntriesC2S;
import net.sixik.sdmshoprework.network.server.edit.SendEditShopEntryC2S;
import net.sixik.sdmshoprework.network.server.move.SendMoveShopEntryC2S;

public abstract class AbstractShopEntryButton
extends SimpleTextButton {
    public AbstractShopEntry entry;
    public boolean isEdit = false;

    public AbstractShopEntryButton(Panel panel, AbstractShopEntry entry) {
        super(panel, (Component)Component.m_237119_(), (Icon)(entry == null ? Icon.empty() : entry.getEntryType().getIcon()));
        this.entry = entry;
    }

    public void addMouseOverText(TooltipList list) {
        if (this.entry != null && this.entry.getEntryType() != null) {
            AbstractShopEntryType abstractShopEntryType = this.entry.getEntryType();
            if (abstractShopEntryType instanceof ShopItemEntryType) {
                ShopItemEntryType entryType = (ShopItemEntryType)abstractShopEntryType;
                ArrayList list1 = new ArrayList();
                GuiHelper.addStackTooltip((ItemStack)entryType.itemStack, list1);
                list1.forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            } else if (!this.entry.title.isEmpty()) {
                list.add((Component)Component.m_237115_((String)this.entry.title));
            }
            if (this.entry.shopSellerType != null) {
                this.entry.shopSellerType.addTooltip(list, this.entry);
            }
            if (!this.entry.descriptionList.isEmpty()) {
                list.add((Component)Component.m_237119_());
                this.entry.descriptionList.stream().map(Component::m_237115_).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
            }
        }
    }

    public void onClicked(MouseButton mouseButton) {
        try {
            if (mouseButton.isLeft()) {
                if (this.isEdit) {
                    List<ContextMenuItem> contextMenu = TypeCreator.createContext(this.getShopScreen());
                    this.getShopScreen().openContextMenu(contextMenu);
                    return;
                }
                if (Screen.m_96637_() && SDMShopR.isEditMode()) {
                    if (this.getShopScreen().selectedEntryID == null) {
                        this.getShopScreen().selectedEntryID = this.entry.entryUUID;
                    } else if (Objects.equals(this.getShopScreen().selectedEntryID, this.entry.entryUUID)) {
                        this.getShopScreen().selectedEntryID = null;
                    } else {
                        tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
                        AbstractShopEntry entry1 = tab.getShopEntry(this.getShopScreen().selectedEntryID);
                        AbstractShopEntry entry2 = tab.getShopEntry(this.entry.entryUUID);
                        ListHelper.swap(tab.getTabEntry(), entry1.getIndex(), entry2.getIndex());
                        this.getShopScreen().selectedEntryID = null;
                        this.getShopScreen().setSelectedTab(entry1.getShopTab());
                        this.getShopScreen().addEntriesButtons();
                        new SendMoveShopEntryC2S(tab.shopTabUUID, entry1.getIndex(), entry2.getIndex()).sendToServer();
                    }
                } else if (Screen.m_96638_() && SDMShopR.isEditMode()) {
                    if (this.entry.getEntryType().getSellType() == AbstractShopEntryType.SellType.BOTH) {
                        tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
                        AbstractShopEntry entry1 = tab.getShopEntry(this.entry.entryUUID);
                        entry1.isSell = !entry1.isSell;
                        this.getShopScreen().setSelectedTab(entry1.getShopTab());
                        this.getShopScreen().addEntriesButtons();
                        new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(entry1.getShopTab().shopTabUUID).serializeNBT()).sendToServer();
                    }
                } else {
                    this.openBuyScreen();
                    this.getShopScreen().refreshWidgets();
                }
            }
            if (mouseButton.isRight() && SDMShopR.isEditMode() && !this.isEdit) {
                ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.edit"), Icons.SETTINGS, button -> {
                    ConfigGroup group = new ConfigGroup("sdmr", b -> {
                        this.openGui();
                        if (b) {
                            new SendEditShopEntryC2S(this.entry.getShopTab().shopTabUUID, this.entry.entryUUID, this.entry.serializeNBT()).sendToServer();
                            this.getShopScreen().refreshWidgets();
                        }
                    }).setNameKey("sidebar_button.sdmr.shop");
                    ConfigGroup g = group.getOrCreateSubgroup("shop").getOrCreateSubgroup("entry");
                    this.entry.getConfig(g);
                    new EditConfigScreen(group).openGui();
                    this.getShopScreen().refreshWidgets();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.duplicate"), Icons.ADD, b -> {
                    ShopTab tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
                    tab.getTabEntry().add(this.entry.copy());
                    this.getShopScreen().setSelectedTab(tab);
                    this.getShopScreen().addEntriesButtons();
                    new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(this.getShopScreen().selectedTab.shopTabUUID).serializeNBT()).sendToServer();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.delete"), Icons.REMOVE, b -> {
                    ShopTab tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
                    tab.removeEntry(this.entry.entryUUID);
                    this.getShopScreen().setSelectedTab(tab);
                    this.getShopScreen().addEntriesButtons();
                    new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(this.getShopScreen().selectedTab.shopTabUUID).serializeNBT()).sendToServer();
                }));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.move.up"), Icons.UP, b -> this.moneEntry(true)));
                contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.shop.entry.context.move.down"), Icons.DOWN, b -> this.moneEntry(false)));
                this.getShopScreen().openContextMenu(contextMenu);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openBuyScreen() {
        new LegacyBuyerScreen(this.entry).openGui();
    }

    public AbstractShopEntryButton setEdit() {
        this.isEdit = true;
        this.icon = Icons.ADD;
        return this;
    }

    public AbstractShopScreen getShopScreen() {
        return (AbstractShopScreen)this.getGui();
    }

    public void moneEntry(boolean isUp) {
        int entryId = this.entry.getIndex();
        ShopTab tab = ShopBase.CLIENT.getShopTab(this.entry.getShopTab().shopTabUUID);
        if (isUp) {
            ListHelper.moveUp(tab.getTabEntry(), entryId);
        } else {
            ListHelper.moveDown(tab.getTabEntry(), entryId);
        }
        this.getShopScreen().setSelectedTab(tab);
        this.getShopScreen().addEntriesButtons();
        new SendChangesShopEntriesC2S(this.getShopScreen().selectedTab.shopTabUUID, ShopBase.CLIENT.getShopTab(this.getShopScreen().selectedTab.shopTabUUID).serializeNBT()).sendToServer();
    }

    public boolean isSelected() {
        return this.getShopScreen().selectedEntryID != null && this.entry != null && Objects.equals(this.getShopScreen().selectedEntryID, this.entry.entryUUID);
    }

    public void drawSelected(GuiGraphics graphics, int x, int y, int w, int h) {
        GuiHelper.drawHollowRect((GuiGraphics)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)Color4I.WHITE, (boolean)false);
    }
}

