/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.api.shop;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.INBTSerializable;
import net.sixik.sdmshoprework.api.ShopSerializerHandler;
import net.sixik.sdmshoprework.api.register.ShopContentRegister;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;
import net.sixik.sdmshoprework.common.data.LimiterData;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopEntry;

public abstract class AbstractShopTab
implements INBTSerializable<CompoundTag> {
    public UUID shopTabUUID;
    private ShopBase shop;
    public Component title = Component.m_237119_();
    public ItemStack icon = Items.f_42127_.m_7968_();
    private final List<AbstractShopEntry> tabEntry = new ArrayList<AbstractShopEntry>();
    private final List<AbstractShopEntryCondition> tabConditions = new ArrayList<AbstractShopEntryCondition>();
    public List<String> descriptionList = new ArrayList<String>();
    public int limit = 0;
    public boolean globalLimit = false;

    public AbstractShopTab(ShopBase shop) {
        this.shop = shop;
        this.shopTabUUID = UUID.randomUUID();
        for (IConstructor<AbstractShopEntryCondition> value : ShopContentRegister.SHOP_ENTRY_CONDITIONS.values()) {
            AbstractShopEntryCondition condition = value.createDefaultInstance();
            if (!Platform.isModLoaded((String)condition.getModId())) continue;
            this.tabConditions.add(condition);
        }
    }

    public void createShopEntry(CompoundTag nbt) {
        ShopEntry entry = new ShopEntry(this);
        entry.deserializeNBT(nbt);
        this.tabEntry.add(entry);
    }

    public ShopBase getShop() {
        return this.shop;
    }

    public List<AbstractShopEntryCondition> getTabConditions() {
        return this.tabConditions;
    }

    public List<AbstractShopEntry> getTabEntry() {
        return this.tabEntry;
    }

    public boolean removeEntry(UUID uuid) {
        Iterator<AbstractShopEntry> it = this.getTabEntry().iterator();
        while (it.hasNext()) {
            AbstractShopEntry entry = it.next();
            if (!entry.entryUUID.equals(uuid)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public AbstractShopEntry getShopEntry(UUID uuid) {
        for (AbstractShopEntry shopEntry : this.tabEntry) {
            if (!Objects.equals(shopEntry.entryUUID, uuid)) continue;
            return shopEntry;
        }
        return null;
    }

    public void getConfig(ConfigGroup config) {
        TooltipList list = new TooltipList();
        list.add((Component)Component.m_237115_((String)"sdmr.shop.tab.title.info"));
        config.addString("title", this.title.getString(), v -> {
            this.title = Component.m_237115_((String)v);
        }, "");
        config.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.icon, v -> {
            this.icon = v;
        }, (Object)Items.f_42127_.m_7968_());
        config.addList("description", this.descriptionList, (ConfigValue)new StringConfig(null), (Object)"");
        config.addInt("limit", this.limit, v -> {
            this.limit = v;
        }, 0, 0, Integer.MAX_VALUE);
        config.addBool("globalLimit", this.globalLimit, v -> {
            this.globalLimit = v;
        }, false);
        ConfigGroup group = config.getOrCreateSubgroup("dependencies");
        for (AbstractShopEntryCondition tabCondition : this.tabConditions) {
            tabCondition.getConfig(group);
        }
    }

    public int getIndex() {
        return this.shop.getShopTabs().indexOf(this);
    }

    public Icon getIcon() {
        if (this.icon.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.icon);
        }
        return ItemIcon.getItemIcon((ItemStack)this.icon);
    }

    @Override
    public CompoundTag serializeNBT() {
        return this.serializeNBT(7);
    }

    public CompoundTag serializeNBT(int bits) {
        return ShopSerializerHandler.serializeShopTab(this, bits);
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.deserializeNBT(nbt, 7);
    }

    public void deserializeNBT(CompoundTag nbt, int bits) {
        ShopSerializerHandler.deserializeShopTab(this, nbt, bits);
    }

    public boolean isLocked() {
        if (SDMShopR.isEditMode()) {
            return false;
        }
        if (this.limit != 0 && LimiterData.CLIENT.TAB_DATA.getOrDefault(this.shopTabUUID, 0) >= this.limit) {
            return true;
        }
        for (AbstractShopEntryCondition tabCondition : this.tabConditions) {
            if (!tabCondition.isLocked()) continue;
            return true;
        }
        return false;
    }
}

