/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.api.shop;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.IModIdentifier;
import net.sixik.sdmshoprework.api.INBTSerializable;
import net.sixik.sdmshoprework.api.register.ShopContentRegister;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractShopEntryType
implements INBTSerializable<CompoundTag>,
IModIdentifier {
    public AbstractShopEntry shopEntry;

    public SellType getSellType() {
        return SellType.BOTH;
    }

    public void setShopEntry(AbstractShopEntry shopEntry) {
        this.shopEntry = shopEntry;
    }

    public static AbstractShopEntryType fromOld(CompoundTag nbt) {
        try {
            String id = nbt.m_128461_("type");
            if (id.equals("itemType")) {
                id = "shopItemEntryType";
                if (nbt.m_128441_("item")) {
                    Tag tag = nbt.m_128423_("item");
                    if (tag instanceof CompoundTag) {
                        CompoundTag it = (CompoundTag)tag;
                        nbt.m_128365_("itemStack", (Tag)it);
                    } else {
                        nbt.m_128359_("itemStack", nbt.m_128461_("item"));
                    }
                }
            }
            AbstractShopEntryType type = (AbstractShopEntryType)((IConstructor)ShopContentRegister.SHOP_ENTRY_TYPES.getOrDefault(id, null)).createDefaultInstance();
            type.deserializeNBT(nbt);
            return type;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static AbstractShopEntryType from(CompoundTag nbt) {
        try {
            String id = nbt.m_128461_("shopEntryTypeID");
            AbstractShopEntryType type = (AbstractShopEntryType)((IConstructor)ShopContentRegister.SHOP_ENTRY_TYPES.getOrDefault(id, null)).createDefaultInstance();
            type.deserializeNBT(nbt);
            return type;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSearch(String search) {
        return true;
    }

    public abstract void getConfig(ConfigGroup var1);

    public abstract AbstractShopEntryType copy();

    public abstract Component getTranslatableForCreativeMenu();

    public List<Component> getDescriptionForContextMenu() {
        return List.of(Component.m_237115_((String)("sdmr.shop.entry.creator.type." + this.getId() + ".description")));
    }

    public boolean isCountable() {
        return true;
    }

    public Icon getCreativeIcon() {
        return Icons.DIAMOND;
    }

    public Icon getIcon() {
        return ItemIcon.getItemIcon((Item)Items.f_42127_);
    }

    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
    }

    public void sell(Player player, int countSell, AbstractShopEntry entry) {
    }

    public void sendNotifiedMessage(Player player) {
    }

    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        long playerMoney = SDMShopR.getMoney(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell);
    }

    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        return 1;
    }

    public String getModNameForContextMenu() {
        return "";
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("shopEntryTypeID", this.getId());
        return nbt;
    }

    public static enum SellType {
        ONLY_SELL,
        ONLY_BUY,
        BOTH;

    }
}

