/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.api.shop;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.ShopSerializerHandler;
import net.sixik.sdmshoprework.api.register.ShopContentRegister;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.api.shop.AbstractShopSellerType;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.common.data.LimiterData;
import net.sixik.sdmshoprework.common.shop.sellerType.MoneySellerType;

public abstract class AbstractShopEntry {
    public static final String DEFAULT_MONEY = "MONEY";
    public UUID entryUUID;
    public String title = "";
    public long entryPrice = 0L;
    public int entryCount = 1;
    public int limit = 0;
    public boolean isSell = false;
    public boolean globalLimit = false;
    public ItemStack icon = Items.f_42127_.m_7968_();
    public List<String> descriptionList = new ArrayList<String>();
    private AbstractShopEntryType entryType = null;
    private AbstractShopTab shopTab;
    public AbstractShopSellerType<?> shopSellerType;
    public String sellerTypeID;
    private final List<AbstractShopEntryCondition> entryConditions = new ArrayList<AbstractShopEntryCondition>();

    public AbstractShopEntry(AbstractShopTab shopTab) {
        this.shopTab = shopTab;
        this.entryUUID = UUID.randomUUID();
        this.shopSellerType = new MoneySellerType();
        this.sellerTypeID = this.shopSellerType.getId();
        for (IConstructor<AbstractShopEntryCondition> value : ShopContentRegister.SHOP_ENTRY_CONDITIONS.values()) {
            AbstractShopEntryCondition condition = value.createDefaultInstance();
            if (!Platform.isModLoaded((String)condition.getModId())) continue;
            this.entryConditions.add(condition);
        }
    }

    public void setEntryPrice(long entryPrice, int entryCount) {
        this.entryPrice = entryPrice;
        this.entryCount = entryCount;
    }

    public void setEntryType(AbstractShopEntryType entryType) {
        this.entryType = entryType;
        this.entryType.setShopEntry(this);
    }

    public AbstractShopTab getShopTab() {
        return this.shopTab;
    }

    public AbstractShopEntryType getEntryType() {
        return this.entryType;
    }

    public List<AbstractShopEntryCondition> getEntryConditions() {
        return this.entryConditions;
    }

    public void getConfig(ConfigGroup config) {
        config.addString("title", this.title, v -> {
            this.title = v;
        }, "");
        ConfigGroup seller = config.getOrCreateSubgroup("seller_type");
        seller.addEnum("seller_type", (Object)this.sellerTypeID, v -> {
            if (!Objects.equals(v, this.sellerTypeID)) {
                this.sellerTypeID = v;
                IConstructor cont = ShopContentRegister.SELLER_TYPES.getOrDefault(this.sellerTypeID, null);
                this.shopSellerType = (AbstractShopSellerType)cont.createDefaultInstance();
            }
        }, this.getList());
        this.shopSellerType.getConfig(seller);
        seller.addLong("price", this.entryPrice, v -> {
            this.entryPrice = v;
        }, 1L, 0L, Long.MAX_VALUE);
        if (this.entryType.getSellType() == AbstractShopEntryType.SellType.BOTH) {
            seller.addBool("isSell", this.isSell, v -> {
                this.isSell = v;
            }, false);
        }
        config.addList("description", this.descriptionList, (ConfigValue)new StringConfig(null), (Object)"");
        ConfigGroup entryGroup = config.getOrCreateSubgroup("type");
        if (this.entryType != null) {
            this.entryType.getConfig(entryGroup);
        }
        if (this.entryType.isCountable()) {
            entryGroup.addInt("count", this.entryCount, v -> {
                this.entryCount = v;
            }, 1, 1, Integer.MAX_VALUE);
        }
        entryGroup.addInt("limit", this.limit, v -> {
            this.limit = v;
        }, 0, 0, Integer.MAX_VALUE);
        entryGroup.addBool("globalLimit", this.globalLimit, v -> {
            this.globalLimit = v;
        }, false);
        ConfigGroup dependenciesGroup = config.getOrCreateSubgroup("dependencies");
        for (AbstractShopEntryCondition entryCondition : this.entryConditions) {
            entryCondition.getConfig(dependenciesGroup);
        }
    }

    public NameMap<String> getList() {
        ArrayList<String> str = new ArrayList<String>();
        for (Map.Entry<String, IConstructor<AbstractShopSellerType<?>>> stringIConstructorEntry : ShopContentRegister.SELLER_TYPES.entrySet()) {
            str.add(stringIConstructorEntry.getKey());
        }
        return NameMap.of((Object)DEFAULT_MONEY, str).create();
    }

    public int getIndex() {
        return this.shopTab.getTabEntry().indexOf(this);
    }

    public boolean isLocked() {
        if (this.limit != 0 && LimiterData.CLIENT.ENTRY_DATA.getOrDefault(this.entryUUID, 0) >= this.limit) {
            return true;
        }
        for (AbstractShopEntryCondition entryCondition : this.entryConditions) {
            if (!entryCondition.isLocked()) continue;
            return true;
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        return this.serializeNBT(7);
    }

    public CompoundTag serializeNBT(int bits) {
        return ShopSerializerHandler.serializeShopEntry(this, bits);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.deserializeNBT(nbt, 7);
    }

    public void deserializeNBT(CompoundTag nbt, int bits) {
        ShopSerializerHandler.deserializeShopEntry(this, nbt, bits);
    }

    public String toString() {
        return "AbstractShopEntry{entryUUID=" + this.entryUUID + ", entryPrice=" + this.entryPrice + ", entryCount=" + this.entryCount + ", entryType=" + this.entryType + ", shopTab=" + this.shopTab + ", entryConditions=" + this.entryConditions + "}";
    }

    public AbstractShopEntry copy() {
        AbstractShopEntry entry = new AbstractShopEntry(this.getShopTab()){};
        entry.entryCount = this.entryCount;
        entry.descriptionList = this.descriptionList;
        entry.entryPrice = this.entryPrice;
        entry.title = this.title;
        entry.limit = this.limit;
        entry.setEntryType(this.getEntryType().copy());
        entry.isSell = this.isSell;
        entry.globalLimit = this.globalLimit;
        entry.icon = this.icon;
        entry.shopSellerType = this.shopSellerType.copy();
        entry.sellerTypeID = this.sellerTypeID;
        entry.entryConditions.clear();
        entry.entryConditions.addAll(this.entryConditions);
        return entry;
    }
}

