/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.register.ShopContentRegister;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.api.shop.AbstractShopSellerType;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.common.shop.ShopTab;
import net.sixik.sdmshoprework.common.shop.sellerType.MoneySellerType;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopSerializerHandler {
    public static List<CompoundTag> serializeShopTabs(ShopBase shop, int bit) {
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        for (ShopTab shopTab : shop.getShopTabs()) {
            list.add(shopTab.serializeNBT(bit));
        }
        return list;
    }

    public static CompoundTag serializeShopEntry(AbstractShopEntry entry, int bit) {
        CompoundTag nbt = new CompoundTag();
        if ((bit & 1) != 0) {
            nbt.m_128362_("entryUUID", entry.entryUUID);
            CompoundTag d = new CompoundTag();
            entry.icon.m_41739_(d);
            nbt.m_128365_("icon", (Tag)d);
            nbt.m_128356_("entryPrice", entry.entryPrice);
            nbt.m_128405_("entryCount", entry.entryCount);
            if (!entry.title.isEmpty()) {
                nbt.m_128359_("title", entry.title);
            }
            nbt.m_128379_("isSell", entry.isSell);
            if (entry.getEntryType() != null) {
                nbt.m_128365_("entryType", (Tag)entry.getEntryType().serializeNBT());
            }
            if (!entry.descriptionList.isEmpty()) {
                ListTag tagDescription = new ListTag();
                for (String s : entry.descriptionList) {
                    tagDescription.add((Object)StringTag.m_129297_((String)s));
                }
                nbt.m_128365_("description", (Tag)tagDescription);
            }
            nbt.m_128365_("shopSeller", (Tag)entry.shopSellerType.serializeNBT());
        }
        if ((bit & 2) != 0 && entry.limit != 0) {
            nbt.m_128405_("limit", entry.limit);
            nbt.m_128379_("globalLimit", entry.globalLimit);
        }
        if ((bit & 3) != 0 && !entry.getEntryConditions().isEmpty()) {
            ListTag tagEntryCondition = new ListTag();
            for (AbstractShopEntryCondition entryCondition : entry.getEntryConditions()) {
                tagEntryCondition.add((Object)entryCondition.serializeNBT());
            }
            nbt.m_128365_("entryCondition", (Tag)tagEntryCondition);
        }
        return nbt;
    }

    public static void deserializeShopEntry(AbstractShopEntry entry, CompoundTag nbt, int bit) {
        if ((bit & 1) != 0) {
            entry.entryPrice = nbt.m_128454_("entryPrice");
            entry.entryCount = nbt.m_128451_("entryCount");
            if (nbt.m_128441_("title")) {
                entry.title = nbt.m_128461_("title");
            }
            entry.entryUUID = nbt.m_128342_("entryUUID");
            entry.icon = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("icon"));
            entry.isSell = nbt.m_128471_("isSell");
            entry.descriptionList.clear();
            if (nbt.m_128441_("description")) {
                ListTag tagDescription = (ListTag)nbt.m_128423_("description");
                for (Tag tag : tagDescription) {
                    entry.descriptionList.add(tag.m_7916_());
                }
            }
            if (nbt.m_128441_("entryType")) {
                entry.setEntryType(AbstractShopEntryType.from(nbt.m_128469_("entryType")));
            }
            if (nbt.m_128441_("shopSeller")) {
                CompoundTag d = nbt.m_128469_("shopSeller");
                entry.sellerTypeID = d.m_128461_("shopSellerTypeID");
                IConstructor cons = ShopContentRegister.SELLER_TYPES.getOrDefault(entry.sellerTypeID, new MoneySellerType.Constructor());
                entry.shopSellerType = (AbstractShopSellerType)cons.createDefaultInstance();
                entry.shopSellerType.deserializeNBT(d);
            } else {
                entry.shopSellerType = new MoneySellerType();
                entry.sellerTypeID = entry.shopSellerType.getId();
            }
        }
        if ((bit & 2) != 0 && nbt.m_128441_("limit")) {
            entry.limit = nbt.m_128451_("limit");
            entry.globalLimit = nbt.m_128471_("globalLimit");
        }
        if ((bit & 3) != 0 && nbt.m_128441_("entryCondition")) {
            entry.getEntryConditions().clear();
            ListTag tagEntryCondition = (ListTag)nbt.m_128423_("entryCondition");
            for (int i = 0; i < tagEntryCondition.size(); ++i) {
                AbstractShopEntryCondition condition = AbstractShopEntryCondition.from(tagEntryCondition.m_128728_(i));
                if (condition == null) continue;
                entry.getEntryConditions().add(condition);
            }
        }
    }

    public static CompoundTag serializeShopTab(AbstractShopTab tab, int bit) {
        CompoundTag nbt = new CompoundTag();
        if ((bit & 1) != 0) {
            NBTUtils.putItemStack(nbt, "icon", tab.icon);
            nbt.m_128362_("shopTabUUID", tab.shopTabUUID);
            nbt.m_128359_("title", tab.title.getString());
            if (!tab.descriptionList.isEmpty()) {
                ListTag tagDescription = new ListTag();
                for (String s : tab.descriptionList) {
                    tagDescription.add((Object)StringTag.m_129297_((String)s));
                }
                nbt.m_128365_("description", (Tag)tagDescription);
            }
        }
        if ((bit & 2) != 0 && tab.limit != 0) {
            nbt.m_128405_("limit", tab.limit);
            nbt.m_128379_("globalLimit", tab.globalLimit);
        }
        if ((bit & 3) != 0 && !tab.getTabConditions().isEmpty()) {
            ListTag tagTabConditions = new ListTag();
            for (AbstractShopEntryCondition tabCondition : tab.getTabConditions()) {
                tagTabConditions.add((Object)tabCondition.serializeNBT());
            }
            nbt.m_128365_("tabCondition", (Tag)tagTabConditions);
        }
        if ((bit & 4) != 0) {
            ListTag tagTabEntries = new ListTag();
            for (AbstractShopEntry shopEntry : tab.getTabEntry()) {
                tagTabEntries.add((Object)shopEntry.serializeNBT());
            }
            nbt.m_128365_("tabEntry", (Tag)tagTabEntries);
        }
        return nbt;
    }

    public static void deserializeShopTab(AbstractShopTab tab, CompoundTag nbt, int bit) {
        if ((bit & 1) != 0) {
            tab.shopTabUUID = nbt.m_128342_("shopTabUUID");
            tab.title = Component.m_237115_((String)nbt.m_128461_("title"));
            tab.icon = NBTUtils.getItemStack(nbt, "icon");
            tab.descriptionList.clear();
            if (nbt.m_128441_("description")) {
                ListTag tagDescription = (ListTag)nbt.m_128423_("description");
                for (Tag tag : tagDescription) {
                    tab.descriptionList.add(tag.m_7916_());
                }
            }
        }
        if ((bit & 2) != 0 && nbt.m_128441_("limit")) {
            tab.limit = nbt.m_128451_("limit");
            tab.globalLimit = nbt.m_128471_("globalLimit");
        }
        if ((bit & 3) != 0 && nbt.m_128441_("tabCondition")) {
            tab.getTabConditions().clear();
            ListTag tagTabConditions = (ListTag)nbt.m_128423_("tabCondition");
            for (int i = 0; i < tagTabConditions.size(); ++i) {
                AbstractShopEntryCondition condition = AbstractShopEntryCondition.from(tagTabConditions.m_128728_(i));
                if (condition == null) continue;
                tab.getTabConditions().add(condition);
            }
        }
        if ((bit & 4) != 0) {
            tab.getTabEntry().clear();
            if (nbt.m_128441_("tabEntry")) {
                ListTag tagEntries = (ListTag)nbt.m_128423_("tabEntry");
                for (Tag tagEntry : tagEntries) {
                    ShopEntry shopEntry = new ShopEntry(tab);
                    shopEntry.deserializeNBT((CompoundTag)tagEntry);
                    tab.getTabEntry().add(shopEntry);
                }
            }
        }
    }

    public static List<CompoundTag> serializeTabEntry(ShopTab tab) {
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>();
        for (AbstractShopEntry entry : tab.getTabEntry()) {
            list.add(entry.serializeNBT());
        }
        return list;
    }

    public static List<AbstractShopEntry> deserializeTabEntry(List<CompoundTag> list, AbstractShopTab tab) {
        ArrayList<AbstractShopEntry> entries = new ArrayList<AbstractShopEntry>();
        for (CompoundTag tag : list) {
            Optional<ShopEntry> optional = ShopEntry.create(tab, tag);
            if (optional.isEmpty()) continue;
            entries.add(optional.get());
        }
        return entries;
    }
}

