/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.SDMShopRework;
import net.sixik.sdmshoprework.network.server.misc.SendConfigS2C;
import net.sixik.sdmshoprework.network.server.misc.SendOpenShopScreenS2C;
import net.sixik.sdmshoprework.network.server.reload.SendReloadConfigS2C;

public class SDMShopCommands {
    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sdmshop").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"balance").executes(context -> SDMShopCommands.balance((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).requires(source -> source.m_6761_(2))).executes(context -> SDMShopCommands.balance((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_()))))).then(Commands.m_82127_((String)"pay").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"money", (ArgumentType)LongArgumentType.longArg((long)1L)).executes(context -> SDMShopCommands.pay((CommandSourceStack)context.getSource(), ((CommandSourceStack)context.getSource()).m_81375_(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"money", (ArgumentType)LongArgumentType.longArg((long)0L)).executes(context -> SDMShopCommands.set((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"money", (ArgumentType)LongArgumentType.longArg()).executes(context -> SDMShopCommands.add((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"), LongArgumentType.getLong((CommandContext)context, (String)"money"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"edit_mode").requires(source -> source.m_6761_(2))).executes(context -> SDMShopCommands.editMode((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadConfig").requires(source -> source.m_6761_(2))).executes(context -> SDMShopCommands.reloadClient((CommandSourceStack)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"open_shop").requires(source -> source.m_6761_(2))).executes(context -> SDMShopCommands.openShop((CommandSourceStack)context.getSource(), null))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> SDMShopCommands.openShop((CommandSourceStack)context.getSource(), EntityArgument.m_91477_((CommandContext)context, (String)"player"))))));
    }

    private static int openShop(CommandSourceStack source, Collection<ServerPlayer> profiles) {
        if (profiles != null) {
            for (ServerPlayer profile : profiles) {
                new SendOpenShopScreenS2C().sendTo(profile);
            }
        } else if (source.m_230896_() != null) {
            new SendOpenShopScreenS2C().sendTo(source.m_230896_());
        }
        return 1;
    }

    private static int reloadClient(CommandSourceStack source) {
        if (source.m_230896_() != null) {
            source.m_288197_(() -> Component.m_237113_((String)"Start Reload"), false);
            new SendConfigS2C().sendToAll(source.m_81377_());
            new SendReloadConfigS2C().sendToAll(source.m_81377_());
        }
        return 1;
    }

    private static int editMode(CommandSourceStack source) {
        if (source.m_230896_() != null) {
            SDMShopR.setEditMode(source.m_230896_(), !SDMShopR.isEditMode((Player)source.m_230896_()));
            source.m_288197_(() -> Component.m_237113_((String)("Edit mode is " + SDMShopR.isEditMode((Player)source.m_230896_()))), false);
        }
        return 1;
    }

    private static int balance(CommandSourceStack source, ServerPlayer profiles) {
        source.m_288197_(() -> Component.m_237113_((String)SDMShopRework.moneyString(SDMShopR.getMoney((Player)profiles))), false);
        return 1;
    }

    private static int pay(CommandSourceStack source, ServerPlayer from, ServerPlayer to, long money) {
        if (from.m_20148_().equals(to.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"You can't send money to yourself"));
            return 1;
        }
        if (SDMShopR.getMoney((Player)from) >= money) {
            SDMShopR.setMoney((Player)from, SDMShopR.getMoney((Player)from) - money);
            SDMShopR.setMoney((Player)to, SDMShopR.getMoney((Player)to) + money);
            source.m_288197_(() -> Component.m_237113_((String)"Money sended !"), false);
            return 0;
        }
        source.m_81352_((Component)Component.m_237113_((String)"Not enough money"));
        return 1;
    }

    private static int set(CommandSourceStack source, Collection<ServerPlayer> players, long money) {
        for (ServerPlayer player : players) {
            SDMShopR.setMoney((Player)player, money);
            source.m_288197_(() -> Component.m_237113_((String)(player.m_6302_() + ": ")).m_130946_(SDMShopRework.moneyString(money)), false);
        }
        return players.size();
    }

    private static int add(CommandSourceStack source, Collection<ServerPlayer> players, long money) {
        if (money == 0L) {
            return 0;
        }
        for (ServerPlayer player : players) {
            source.m_288197_(() -> Component.m_237113_((String)(player.m_6302_() + (money > 0L ? ": +" : ": -"))).m_130946_(SDMShopRework.moneyString(Math.abs(money))), false);
            SDMShopR.addMoney((Player)player, money);
        }
        return players.size();
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> commandSourceStackCommandDispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        SDMShopCommands.registerCommands(commandSourceStackCommandDispatcher);
    }
}

