/*
 * Decompiled with CFR 0.152.
 */
package com.ezzenix.smoothgui.mixin;

import com.ezzenix.smoothgui.SmoothGui;
import com.ezzenix.smoothgui.config.ModConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Screen.class})
public class ScreenMixin {
    @Unique
    private static final int COLOR_TOP = -1072689136;
    @Unique
    private static final int COLOR_BOTTOM = -804253680;

    @Inject(method={"renderWithTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.BEFORE)})
    private void screenRender(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (!SmoothGui.isValidScreen((Screen)this)) {
            return;
        }
        SmoothGui.push(guiGraphics);
    }

    @Inject(method={"renderWithTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    private void screenRenderEnd(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        SmoothGui.pop(guiGraphics);
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")})
    private void onRenderBackground(GuiGraphics guiGraphics, CallbackInfo ci) {
        SmoothGui.pop(guiGraphics);
    }

    @Inject(method={"renderBackground"}, at={@At(value="TAIL")})
    private void onRenderBackgroundEnd(GuiGraphics guiGraphics, CallbackInfo ci) {
        if (!SmoothGui.isValidScreen((Screen)this)) {
            return;
        }
        SmoothGui.push(guiGraphics);
    }

    @Unique
    private int applyFade(int color) {
        if (!SmoothGui.isValidScreen((Screen)this) || !ModConfig.getConfig().fadeBackground) {
            return color;
        }
        float fade = Math.min(SmoothGui.getAlphaSince(SmoothGui.lastScreenOpenedTime) * 2.6f, 1.0f);
        if (fade == 1.0f) {
            return color;
        }
        int a = (int)((float)(color >> 24 & 0xFF) * fade);
        return a << 24 | color & 0xFFFFFF;
    }

    @ModifyArg(method={"renderBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fillGradient(IIIIII)V"), index=4)
    public int renderTransparentBackgroundColor1(int x) {
        return this.applyFade(-1072689136);
    }

    @ModifyArg(method={"renderBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;fillGradient(IIIIII)V"), index=5)
    public int renderTransparentBackgroundColor2(int x) {
        return this.applyFade(-804253680);
    }
}

