/*
 * Decompiled with CFR 0.152.
 */
package net.prizowo.filejs.kubejs;

import dev.latvian.mods.kubejs.event.EventJS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.prizowo.filejs.FilesJSPlugin;
import net.prizowo.filejs.Filesjs;
import net.prizowo.filejs.kubejs.FileEventJS;

public class FilesWrapper {
    private final Map<String, WatchService> watchServices = new HashMap<String, WatchService>();
    private Object currentTickListener = null;

    private Path validateAndNormalizePath(String path) {
        Path minecraftDir = FMLPaths.GAMEDIR.get().normalize().toAbsolutePath();
        path = path.replace('\\', '/');
        return minecraftDir.resolve(path).normalize().toAbsolutePath();
    }

    public String readFile(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            return new String(Files.readAllBytes(normalizedPath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error reading file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to read file: " + path, e);
        }
    }

    public List<String> readLines(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            return Files.readAllLines(normalizedPath, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error reading lines from file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to read lines from file: " + path, e);
        }
    }

    public void writeFile(String path, String content) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            Files.write(normalizedPath, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            boolean isNewFile = !Files.exists(normalizedPath, new LinkOption[0]);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            if (isNewFile) {
                FilesJSPlugin.FILE_CREATED.post((EventJS)new FileEventJS(path, content, "created", null, server, level));
            } else {
                FilesJSPlugin.FILE_CHANGED.post((EventJS)new FileEventJS(path, content, "changed", null, server, level));
            }
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error writing file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to write file: " + path, e);
        }
    }

    public void writeLines(String path, List<String> lines) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            Files.write(normalizedPath, lines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error writing lines to file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to write lines to file: " + path, e);
        }
    }

    public void appendFile(String path, String content) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            Files.write(normalizedPath, content.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error appending to file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to append to file: " + path, e);
        }
    }

    public boolean exists(String path) {
        Path normalizedPath = this.validateAndNormalizePath(path);
        return Files.exists(normalizedPath, new LinkOption[0]);
    }

    public void createDirectory(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            Files.createDirectories(normalizedPath, new FileAttribute[0]);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            FilesJSPlugin.DIRECTORY_CREATED.post((EventJS)new FileEventJS(path, null, "directory_created", null, server, level));
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error creating directory: " + path, (Throwable)e);
            throw new RuntimeException("Failed to create directory: " + path, e);
        }
    }

    public void delete(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            boolean isDirectory = Files.isDirectory(normalizedPath, new LinkOption[0]);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            FileEventJS event = new FileEventJS(path, null, isDirectory ? "directory_deleted" : "deleted", null, server, level);
            Files.delete(normalizedPath);
            if (isDirectory) {
                FilesJSPlugin.DIRECTORY_DELETED.post((EventJS)event);
            } else {
                FilesJSPlugin.FILE_DELETED.post((EventJS)event);
            }
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error deleting file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to delete file: " + path, e);
        }
    }

    public List<String> listFiles(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            return Files.list(normalizedPath).filter(p -> Files.isRegularFile(p, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error listing files: " + path, (Throwable)e);
            throw new RuntimeException("Failed to list files: " + path, e);
        }
    }

    public List<String> listDirectories(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            return Files.list(normalizedPath).filter(p -> Files.isDirectory(p, new LinkOption[0])).map(Path::toString).collect(Collectors.toList());
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error listing directories: " + path, (Throwable)e);
            throw new RuntimeException("Failed to list directories: " + path, e);
        }
    }

    public void copy(String source, String target) {
        try {
            Path sourcePath = this.validateAndNormalizePath(source);
            Path targetPath = this.validateAndNormalizePath(target);
            FileEventJS event = new FileEventJS(target, null, "copied", null, ServerLifecycleHooks.getCurrentServer(), ServerLifecycleHooks.getCurrentServer().m_129783_());
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            FilesJSPlugin.FILE_COPIED.post((EventJS)event);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error copying file: " + source + " -> " + target, (Throwable)e);
            throw new RuntimeException("Failed to copy file: " + source + " -> " + target, e);
        }
    }

    public void move(String source, String target) {
        try {
            Path sourcePath = this.validateAndNormalizePath(source);
            Path targetPath = this.validateAndNormalizePath(target);
            Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            String content = new String(Files.readAllBytes(targetPath), StandardCharsets.UTF_8);
            FilesJSPlugin.FILE_MOVED.post((EventJS)new FileEventJS(target, content, "moved", null, server, level));
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error moving file: " + source + " -> " + target, (Throwable)e);
            throw new RuntimeException("Failed to move file: " + source + " -> " + target, e);
        }
    }

    public void appendLine(String path, String line) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(line);
            Files.write(normalizedPath, lines, StandardCharsets.UTF_8, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error appending line to file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to append line to file: " + path, e);
        }
    }

    public void ensureDirectoryExists(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            if (!Files.exists(normalizedPath, new LinkOption[0])) {
                Files.createDirectories(normalizedPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error creating directory: " + path, (Throwable)e);
            throw new RuntimeException("Failed to create directory: " + path, e);
        }
    }

    public void saveJson(String path, String jsonContent) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            Path parent = normalizedPath.getParent();
            if (parent != null) {
                String parentPath = FMLPaths.GAMEDIR.get().relativize(parent).toString().replace('\\', '/');
                this.ensureDirectoryExists(parentPath);
            }
            this.writeFile(path, jsonContent);
        }
        catch (RuntimeException e) {
            Filesjs.LOGGER.error("Error saving JSON file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to save JSON file: " + path, e);
        }
    }

    public void saveScript(String path, String scriptContent) {
        try {
            Path normalizedPath;
            Path parent;
            if (!((String)path).endsWith(".js")) {
                path = (String)path + ".js";
            }
            if ((parent = (normalizedPath = this.validateAndNormalizePath((String)path)).getParent()) != null) {
                String parentPath = FMLPaths.GAMEDIR.get().relativize(parent).toString().replace('\\', '/');
                this.ensureDirectoryExists(parentPath);
            }
            String formattedScript = String.format("// Generated by FilesJS\n// Created at: %s\n\n%s", LocalDateTime.now(), scriptContent);
            this.writeFile((String)path, formattedScript);
        }
        catch (RuntimeException e) {
            Filesjs.LOGGER.error("Error saving script file: " + (String)path, (Throwable)e);
            throw new RuntimeException("Failed to save script file: " + (String)path, e);
        }
    }

    public List<String> readLastLines(String path, int n) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            List<String> allLines = Files.readAllLines(normalizedPath, StandardCharsets.UTF_8);
            int start = Math.max(0, allLines.size() - n);
            return allLines.subList(start, allLines.size());
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error reading last lines: " + path, (Throwable)e);
            throw new RuntimeException("Failed to read last lines: " + path, e);
        }
    }

    public List<String> searchInFile(String path, String searchTerm) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            return Files.lines(normalizedPath).filter(line -> line.contains(searchTerm)).collect(Collectors.toList());
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error searching in file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to search in file: " + path, e);
        }
    }

    public Map<String, Object> getFileInfo(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("exists", Files.exists(normalizedPath, new LinkOption[0]));
            if (Files.exists(normalizedPath, new LinkOption[0])) {
                info.put("size", Files.size(normalizedPath));
                info.put("lastModified", Files.getLastModifiedTime(normalizedPath, new LinkOption[0]).toMillis());
                info.put("isDirectory", Files.isDirectory(normalizedPath, new LinkOption[0]));
                info.put("isFile", Files.isRegularFile(normalizedPath, new LinkOption[0]));
                info.put("isReadable", Files.isReadable(normalizedPath));
                info.put("isWritable", Files.isWritable(normalizedPath));
            }
            return info;
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error getting file info: " + path, (Throwable)e);
            throw new RuntimeException("Failed to get file info: " + path, e);
        }
    }

    public List<String> listFilesRecursively(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            ArrayList<String> files = new ArrayList<String>();
            Files.walk(normalizedPath, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0])).map(Path::toString).forEach(files::add);
            return files;
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error listing files recursively: " + path, (Throwable)e);
            throw new RuntimeException("Failed to list files recursively: " + path, e);
        }
    }

    public void copyFiles(String sourceDir, String targetDir, String pattern) {
        try {
            Path sourcePath = this.validateAndNormalizePath(sourceDir);
            Path targetPath = this.validateAndNormalizePath(targetDir);
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
            Files.walk(sourcePath, new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && matcher.matches(path.getFileName())).forEach(source -> {
                try {
                    Path target = targetPath.resolve(sourcePath.relativize((Path)source));
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    Filesjs.LOGGER.error("Error copying file: " + source, (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error in batch copy operation", (Throwable)e);
            throw new RuntimeException("Failed in batch copy operation", e);
        }
    }

    public void backupFile(String path) {
        try {
            Path sourcePath = this.validateAndNormalizePath(path);
            String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String backupName = sourcePath.getFileName().toString() + "." + timestamp + ".backup";
            Path backupDir = Paths.get("kubejs/backups", new String[0]);
            Path backupPath = backupDir.resolve(backupName);
            this.validateAndNormalizePath(backupPath.toString());
            Files.createDirectories(backupDir, new FileAttribute[0]);
            Files.copy(sourcePath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            FilesJSPlugin.FILE_BACKUP_CREATED.post((EventJS)new FileEventJS(backupPath.toString(), null, "backup_created", null, server, level));
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error creating backup: " + path, (Throwable)e);
            throw new RuntimeException("Failed to create backup: " + path, e);
        }
    }

    public boolean isFileEmpty(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            return Files.size(normalizedPath) == 0L;
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error checking if file is empty: " + path, (Throwable)e);
            throw new RuntimeException("Failed to check if file is empty: " + path, e);
        }
    }

    public void mergeFiles(List<String> sourcePaths, String targetPath) {
        try {
            ArrayList<Path> normalizedSourcePaths = new ArrayList<Path>();
            for (String path : sourcePaths) {
                normalizedSourcePaths.add(this.validateAndNormalizePath(path));
            }
            Path normalizedTargetPath = this.validateAndNormalizePath(targetPath);
            ArrayList<String> mergedContent = new ArrayList<String>();
            for (Path path : normalizedSourcePaths) {
                mergedContent.addAll(Files.readAllLines(path, StandardCharsets.UTF_8));
                mergedContent.add("");
            }
            Files.write(normalizedTargetPath, mergedContent, StandardCharsets.UTF_8, new OpenOption[0]);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            FilesJSPlugin.FILES_MERGED.post((EventJS)new FileEventJS(targetPath, String.join((CharSequence)"\n", mergedContent), "merged", null, server, level));
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error merging files to: " + targetPath, (Throwable)e);
            throw new RuntimeException("Failed to merge files: " + targetPath, e);
        }
    }

    public void replaceInFile(String path, String search, String replace) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            String content = new String(Files.readAllBytes(normalizedPath), StandardCharsets.UTF_8);
            String newContent = content.replace(search, replace);
            Files.write(normalizedPath, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error replacing content in file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to replace content in file: " + path, e);
        }
    }

    public void processLargeFile(String path, Consumer<String> lineProcessor) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            try (BufferedReader reader = Files.newBufferedReader(normalizedPath);){
                String line;
                while ((line = reader.readLine()) != null) {
                    lineProcessor.accept(line);
                }
            }
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error processing large file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to process large file: " + path, e);
        }
    }

    public String getFileMD5(String path) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(Files.readAllBytes(normalizedPath));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            Filesjs.LOGGER.error("Error calculating MD5 for file: " + path, (Throwable)e);
            throw new RuntimeException("Failed to calculate MD5: " + path, e);
        }
    }

    public boolean compareFiles(String path1, String path2) {
        try {
            Path normalizedPath1 = this.validateAndNormalizePath(path1);
            Path normalizedPath2 = this.validateAndNormalizePath(path2);
            return Arrays.equals(Files.readAllBytes(normalizedPath1), Files.readAllBytes(normalizedPath2));
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error comparing files: " + path1 + " vs " + path2, (Throwable)e);
            throw new RuntimeException("Failed to compare files", e);
        }
    }

    public void createZip(String sourcePath, String zipPath) {
        try {
            Path source = this.validateZipPath(sourcePath);
            Path zip = this.validateAndNormalizePath(zipPath);
            if (!Files.exists(source, new LinkOption[0])) {
                throw new IOException("Source directory does not exist: " + sourcePath);
            }
            Path zipParent = zip.getParent();
            if (zipParent != null) {
                Files.createDirectories(zipParent, new FileAttribute[0]);
            }
            try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zip, new OpenOption[0]));){
                Files.walk(source, new FileVisitOption[0]).forEach(path -> {
                    try {
                        Object relativePath = source.relativize((Path)path).toString().replace('\\', '/');
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            relativePath = (String)relativePath + "/";
                        }
                        zos.putNextEntry(new ZipEntry((String)relativePath));
                        if (!Files.isDirectory(path, new LinkOption[0])) {
                            Files.copy(path, zos);
                        }
                        zos.closeEntry();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
        }
        catch (IOException | UncheckedIOException e) {
            Filesjs.LOGGER.error("Error creating zip file: " + zipPath, (Throwable)e);
            throw new RuntimeException("Failed to create zip file: " + zipPath, e);
        }
    }

    private Path validateZipPath(String path) {
        return Paths.get(FMLPaths.GAMEDIR.get().toString(), path).normalize();
    }

    public void watchDirectory(String path, Consumer<Path> changeCallback) {
        WatchService watchService;
        Path normalizedPath = this.validateAndNormalizePath(path);
        FileEventJS watchEvent = new FileEventJS(path, null, "watch_started", null, ServerLifecycleHooks.getCurrentServer(), ServerLifecycleHooks.getCurrentServer().m_129783_());
        try {
            watchService = FileSystems.getDefault().newWatchService();
            normalizedPath.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error creating watch service: " + path, (Throwable)e);
            throw new RuntimeException("Failed to create watch service: " + path, e);
        }
        this.watchServices.put(path, watchService);
        Thread watchThread = new Thread(() -> {
            try {
                while (true) {
                    WatchKey key = watchService.take();
                    Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                    while (iterator.hasNext()) {
                        WatchEvent<?> watchedEvent;
                        WatchEvent<?> pathEvent = watchedEvent = iterator.next();
                        Path changed = normalizedPath.resolve((Path)pathEvent.context());
                        changeCallback.accept(changed);
                    }
                    key.reset();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        });
        watchThread.setDaemon(true);
        watchThread.start();
    }

    public void stopWatching(String path) {
        block4: {
            try {
                Path normalizedPath = this.validateAndNormalizePath(path);
                WatchService watchService = this.watchServices.remove(normalizedPath.toString());
                if (watchService == null) break block4;
                try {
                    watchService.close();
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    ServerLevel level = server.m_129783_();
                    FilesJSPlugin.FILE_WATCH_STOPPED.post((EventJS)new FileEventJS(path, null, "watch_stopped", null, server, level));
                }
                catch (IOException e) {
                    Filesjs.LOGGER.error("Error closing file watcher: " + path, (Throwable)e);
                    throw new RuntimeException("Failed to close file watcher: " + path, e);
                }
            }
            catch (RuntimeException e) {
                Filesjs.LOGGER.error("Error stopping file watcher: " + path, (Throwable)e);
                throw e;
            }
        }
    }

    public void watchContentChanges(String path, double threshold) {
        try {
            Path normalizedPath = this.validateAndNormalizePath(path);
            Path parentDir = normalizedPath.getParent();
            Path fileName = normalizedPath.getFileName();
            String originalContent = new String(Files.readAllBytes(normalizedPath), StandardCharsets.UTF_8);
            String relativeParentDir = FMLPaths.GAMEDIR.get().relativize(parentDir).toString().replace('\\', '/');
            this.watchDirectory(relativeParentDir, changedPath -> {
                try {
                    String newContent;
                    double similarity;
                    if (changedPath.getFileName().equals(fileName) && Files.exists(changedPath, new LinkOption[0]) && 1.0 - (similarity = this.calculateSimilarity(originalContent, newContent = new String(Files.readAllBytes(changedPath), StandardCharsets.UTF_8))) > threshold) {
                        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                        ServerLevel level = server.m_129783_();
                        FilesJSPlugin.FILE_CONTENT_CHANGED_SIGNIFICANTLY.post((EventJS)new FileEventJS(path, newContent, "content_changed_significantly", null, server, level));
                    }
                }
                catch (IOException e) {
                    Filesjs.LOGGER.error("Error checking content changes: " + path, (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error setting up content watch: " + path, (Throwable)e);
            throw new RuntimeException("Failed to set up content watch: " + path, e);
        }
    }

    private double calculateSimilarity(String text1, String text2) {
        if (text1 == null || text2 == null) {
            return 0.0;
        }
        int[][] dp = new int[text1.length() + 1][text2.length() + 1];
        for (int i = 1; i <= text1.length(); ++i) {
            for (int j = 1; j <= text2.length(); ++j) {
                dp[i][j] = text1.charAt(i - 1) == text2.charAt(j - 1) ? dp[i - 1][j - 1] + 1 : Math.max(dp[i - 1][j], dp[i][j - 1]);
            }
        }
        int lcsLength = dp[text1.length()][text2.length()];
        int maxLength = Math.max(text1.length(), text2.length());
        return maxLength > 0 ? (double)lcsLength / (double)maxLength : 1.0;
    }

    public void scheduleBackup(final String path, final int ticks) {
        final Path normalizedPath = this.validateAndNormalizePath(path);
        if (ticks == 0) {
            this.doBackup(normalizedPath.toString());
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            Object listener;
            if (this.currentTickListener != null) {
                MinecraftForge.EVENT_BUS.unregister(this.currentTickListener);
            }
            final int[] tickCounter = new int[]{0};
            this.currentTickListener = listener = new Object(){

                @SubscribeEvent
                public void onServerTick(TickEvent.ServerTickEvent event) {
                    if (event.phase == TickEvent.Phase.END) {
                        tickCounter[0] = tickCounter[0] + 1;
                        if (tickCounter[0] >= ticks) {
                            try {
                                FilesWrapper.this.doBackup(normalizedPath.toString());
                            }
                            catch (Exception e) {
                                Filesjs.LOGGER.error("Error during scheduled backup: " + path, (Throwable)e);
                            }
                            MinecraftForge.EVENT_BUS.unregister((Object)this);
                            FilesWrapper.this.currentTickListener = null;
                        }
                    }
                }
            };
            MinecraftForge.EVENT_BUS.register(listener);
        }
    }

    private void doBackup(String path) {
        try {
            Path sourcePath = this.validateAndNormalizePath(path);
            Path backupDir = Paths.get("kubejs/backups", new String[0]);
            Files.createDirectories(backupDir, new FileAttribute[0]);
            String timestamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
            String fileName = sourcePath.getFileName().toString();
            String backupName = fileName + "." + timestamp + ".backup";
            Path backupPath = backupDir.resolve(backupName);
            this.validateAndNormalizePath(backupPath.toString());
            Files.copy(sourcePath, backupPath, StandardCopyOption.REPLACE_EXISTING);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            FilesJSPlugin.FILE_BACKUP_CREATED.post((EventJS)new FileEventJS(backupPath.toString(), null, "backup_created", null, server, level));
            this.cleanupOldBackups(backupDir, 5);
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error creating backup: " + path, (Throwable)e);
            throw new RuntimeException("Failed to create backup: " + path, e);
        }
    }

    private void cleanupOldBackups(Path backupDir, int keepCount) throws IOException {
        if (!Files.exists(backupDir, new LinkOption[0])) {
            return;
        }
        List backups = Files.list(backupDir).filter(path -> path.toString().endsWith(".backup")).sorted((a, b) -> {
            try {
                return Files.getLastModifiedTime(b, new LinkOption[0]).compareTo(Files.getLastModifiedTime(a, new LinkOption[0]));
            }
            catch (IOException e) {
                return 0;
            }
        }).collect(Collectors.toList());
        if (backups.size() > keepCount) {
            for (Path backup : backups.subList(keepCount, backups.size())) {
                Files.delete(backup);
            }
        }
    }

    private FileEventJS createFileEvent(String path, String content, String type) {
        Path normalizedPath = this.validateAndNormalizePath(path);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerLevel level = server.m_129783_();
        return new FileEventJS(normalizedPath.toString(), content, type, null, server, level);
    }

    public void renameFile(String oldPath, String newPath) {
        try {
            Path sourcePath = this.validateAndNormalizePath(oldPath);
            Path targetPath = this.validateAndNormalizePath(newPath);
            String content = new String(Files.readAllBytes(sourcePath), StandardCharsets.UTF_8);
            Files.move(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            ServerLevel level = server.m_129783_();
            FilesJSPlugin.FILE_RENAMED.post((EventJS)new FileEventJS(newPath, content, "renamed", null, server, level));
        }
        catch (IOException e) {
            Filesjs.LOGGER.error("Error renaming file: " + oldPath + " -> " + newPath, (Throwable)e);
            throw new RuntimeException("Failed to rename file: " + oldPath + " -> " + newPath, e);
        }
    }
}

