/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalApiRegistry;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.interfaces.CustomTeleportingEntity;
import net.kyrptonaught.customportalapi.portal.PortalPlacer;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.portal.linking.DimensionalBlockPos;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.kyrptonaught.customportalapi.util.SHOULDTP;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;

public class CustomTeleporter {
    public static void TPToDim(Level world, Entity entity, Block portalBase, BlockPos portalPos) {
        PortalLink link = CustomPortalApiRegistry.getPortalLinkFromBase(portalBase);
        if (link == null) {
            return;
        }
        if (link.getBeforeTPEvent().execute(entity) == SHOULDTP.CANCEL_TP) {
            return;
        }
        ResourceKey<Level> destKey = world.m_46472_() == CustomPortalsMod.dims.get(link.dimID) ? CustomPortalsMod.dims.get(link.returnDimID) : CustomPortalsMod.dims.get(link.dimID);
        ServerLevel destination = ((ServerLevel)world).m_7654_().m_129880_(destKey);
        if (destination == null) {
            return;
        }
        PortalInfo target = CustomTeleporter.customTPTarget(destination, entity, portalPos, portalBase, link.getFrameTester());
        ((CustomTeleportingEntity)entity).setCustomTeleportTarget(target);
        entity = entity.m_5489_(destination);
        if (entity != null) {
            entity.m_146922_(target.f_77678_);
            entity.m_146926_(target.f_77679_);
            if (entity instanceof ServerPlayer) {
                entity.m_20219_(target.f_77676_);
            }
            link.executePostTPEvent(entity);
        }
    }

    public static PortalInfo customTPTarget(ServerLevel destinationWorld, Entity entity, BlockPos enteredPortalPos, Block frameBlock, PortalFrameTester.PortalFrameTesterFactory portalFrameTesterFactory) {
        PortalFrameTester portalFrameTester;
        Direction.Axis portalAxis = CustomPortalHelper.getAxisFrom(entity.m_9236_().m_8055_(enteredPortalPos));
        BlockUtil.FoundRectangle fromPortalRectangle = portalFrameTesterFactory.createInstanceOfPortalFrameTester().init((LevelAccessor)entity.m_9236_(), enteredPortalPos, portalAxis, frameBlock).getRectangle();
        if (fromPortalRectangle.f_124348_ == null) {
            return null;
        }
        DimensionalBlockPos destinationPos = CustomPortalsMod.portalLinkingStorage.getDestination(fromPortalRectangle.f_124348_, (ResourceKey<Level>)entity.m_9236_().m_46472_());
        if (destinationPos != null && destinationPos.dimensionType.equals((Object)destinationWorld.m_46472_().m_135782_()) && (portalFrameTester = portalFrameTesterFactory.createInstanceOfPortalFrameTester().init((LevelAccessor)destinationWorld, destinationPos.pos, portalAxis, frameBlock)).isValidFrame()) {
            if (!portalFrameTester.isAlreadyLitPortalFrame()) {
                portalFrameTester.lightPortal(frameBlock);
            }
            return portalFrameTester.getTPTargetInPortal(portalFrameTester.getRectangle(), portalAxis, portalFrameTester.getEntityOffsetInPortal(fromPortalRectangle, entity, portalAxis), entity);
        }
        return CustomTeleporter.createDestinationPortal(destinationWorld, entity, portalAxis, fromPortalRectangle, frameBlock.m_49966_());
    }

    public static PortalInfo createDestinationPortal(ServerLevel destination, Entity entity, Direction.Axis axis, BlockUtil.FoundRectangle portalFramePos, BlockState frameBlock) {
        WorldBorder worldBorder = destination.m_6857_();
        double xMin = Math.max(-2.9999872E7, worldBorder.m_61955_() + 16.0);
        double zMin = Math.max(-2.9999872E7, worldBorder.m_61956_() + 16.0);
        double xMax = Math.min(2.9999872E7, worldBorder.m_61957_() - 16.0);
        double zMax = Math.min(2.9999872E7, worldBorder.m_61958_() - 16.0);
        double scaleFactor = DimensionType.m_63908_((DimensionType)entity.m_9236_().m_6042_(), (DimensionType)destination.m_6042_());
        BlockPos blockPos3 = BlockPos.m_274561_((double)Mth.m_14008_((double)(entity.m_20185_() * scaleFactor), (double)xMin, (double)xMax), (double)entity.m_20186_(), (double)Mth.m_14008_((double)(entity.m_20189_() * scaleFactor), (double)zMin, (double)zMax));
        Optional<BlockUtil.FoundRectangle> portal = PortalPlacer.createDestinationPortal(destination, blockPos3, frameBlock, axis);
        if (portal.isPresent()) {
            PortalFrameTester portalFrameTester = CustomPortalApiRegistry.getPortalLinkFromBase(frameBlock.m_60734_()).getFrameTester().createInstanceOfPortalFrameTester();
            CustomPortalsMod.portalLinkingStorage.createLink(portalFramePos.f_124348_, (ResourceKey<Level>)entity.m_9236_().m_46472_(), portal.get().f_124348_, (ResourceKey<Level>)destination.m_46472_());
            return portalFrameTester.getTPTargetInPortal(portal.get(), axis, portalFrameTester.getEntityOffsetInPortal(portalFramePos, entity, axis), entity);
        }
        return CustomTeleporter.idkWhereToPutYou(destination, entity, blockPos3);
    }

    protected static PortalInfo idkWhereToPutYou(ServerLevel world, Entity entity, BlockPos pos) {
        CustomPortalsMod.logError("Unable to find tp location, forced to place on top of world");
        BlockPos destinationPos = world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos);
        return new PortalInfo(new Vec3((double)destinationPos.m_123341_() + 0.5, (double)destinationPos.m_123342_(), (double)destinationPos.m_123343_() + 0.5), entity.m_20184_(), entity.m_146908_(), entity.m_146909_());
    }
}

