/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.mixin;

import net.kyrptonaught.customportalapi.interfaces.CustomTeleportingEntity;
import net.kyrptonaught.customportalapi.interfaces.EntityInCustomPortal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements EntityInCustomPortal,
CustomTeleportingEntity {
    @Shadow
    public Level f_19853_;
    @Unique
    boolean didTP = false;
    @Unique
    int timeInPortal = 0;
    @Unique
    int maxTimeInPortal = 80;
    @Unique
    int cooldown = 0;
    @Unique
    private BlockPos inPortalPos;
    private PortalInfo customTPTarget;

    @Override
    @Unique
    public boolean didTeleport() {
        return this.didTP;
    }

    @Override
    @Unique
    public void setDidTP(boolean didTP) {
        this.didTP = didTP;
        if (didTP) {
            this.timeInPortal = this.maxTimeInPortal;
            this.cooldown = 10;
        } else {
            this.timeInPortal = 0;
            this.cooldown = 0;
        }
    }

    @Override
    @Unique
    public int getTimeInPortal() {
        return this.timeInPortal;
    }

    @Override
    @Unique
    public void tickInPortal(BlockPos portalPos) {
        this.cooldown = 10;
        this.inPortalPos = portalPos;
    }

    @Override
    @Unique
    public BlockPos getInPortalPos() {
        return this.inPortalPos;
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void CPAinCustomPortal(CallbackInfo ci) {
        if (this.cooldown > 0) {
            --this.cooldown;
            this.timeInPortal = Math.min(this.timeInPortal + 1, this.maxTimeInPortal);
            if (this.cooldown <= 0) {
                this.setDidTP(false);
            }
        }
    }

    @Override
    @Unique
    public void setCustomTeleportTarget(PortalInfo teleportTarget) {
        this.customTPTarget = teleportTarget;
    }

    @Override
    @Unique
    public PortalInfo getCustomTeleportTarget() {
        return this.customTPTarget;
    }

    @Inject(method={"findDimensionEntryPoint"}, at={@At(value="HEAD")}, cancellable=true)
    public void CPAgetCustomTPTarget(ServerLevel destination, CallbackInfoReturnable<PortalInfo> cir) {
        if (this.didTeleport()) {
            cir.setReturnValue((Object)this.getCustomTeleportTarget());
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void CPAreadCustomPortalFromTag(CompoundTag tag, CallbackInfo ci) {
        this.didTP = tag.m_128471_("cpadidTP");
        this.cooldown = tag.m_128451_("cpaCooldown");
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="RETURN")})
    public void CPAwriteCustomPortalToTag(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        ((CompoundTag)cir.getReturnValue()).m_128379_("cpadidTP", this.didTP);
        ((CompoundTag)cir.getReturnValue()).m_128405_("cpaCooldown", this.cooldown);
    }
}

