/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib.mixin;

import java.util.Objects;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibAPI;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;
import me.emafire003.dev.coloredglowlib.util.ColorUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1297.class})
public abstract class EntityColorMixin {
    @Unique
    private ColorUtils.RainbowChanger rainbowColor = new ColorUtils.RainbowChanger(255, 0, 0);
    @Unique
    int random_delay_counter = 0;
    @Unique
    int prev_random_color = ColorUtils.toColorValue("#ffffff");

    @Unique
    public int handleCustomColor(String color) {
        if (color.startsWith("#")) {
            color = color.replaceAll("#", "");
        }
        for (CustomColorAnimation customColorAnimation : ColoredGlowLibMod.getCustomColorAnimations()) {
            if (!color.equalsIgnoreCase(customColorAnimation.getName())) continue;
            int color_index = customColorAnimation.getCurrentColorIndex();
            int current_ticks = customColorAnimation.getCurrentTicks();
            if (current_ticks > customColorAnimation.getColorAnimations().get(color_index).getActiveFor()) {
                ++color_index;
                current_ticks = 0;
            }
            if (color_index > customColorAnimation.getColorAnimations().size() - 1) {
                color_index = 0;
            }
            customColorAnimation.setCurrentColorIndex(color_index);
            customColorAnimation.setCurrentTicks(++current_ticks);
            String custom_color = customColorAnimation.getColorAnimations().get(color_index).getColor();
            if (custom_color.equalsIgnoreCase("rainbow")) {
                return this.getRainbowColor();
            }
            if (custom_color.equalsIgnoreCase("random")) {
                return this.randomColor();
            }
            if (!custom_color.equalsIgnoreCase(customColorAnimation.getName()) && ColorUtils.isCustomAnimation(custom_color)) {
                return this.handleCustomColor(custom_color);
            }
            return ColorUtils.toColorValue(custom_color);
        }
        return -1;
    }

    @Unique
    private int getRainbowColor() {
        if (this.rainbowColor == null) {
            ColoredGlowLibMod.LOGGER.warn("rainbowColor was null, reinitialising");
            this.rainbowColor = new ColorUtils.RainbowChanger(255, 0, 0);
        }
        this.rainbowColor.setRainbowColor(10);
        return this.rainbowColor.getColorValue();
    }

    @Unique
    private int randomColor() {
        class_1297 entity = (class_1297)this;
        class_5819 r = entity.method_37908().method_8409();
        if (this.random_delay_counter == 10) {
            this.random_delay_counter = 0;
            this.prev_random_color = ColorUtils.toColorValue(r.method_39332(0, 255), r.method_39332(0, 255), r.method_39332(0, 255));
        } else {
            ++this.random_delay_counter;
        }
        return this.prev_random_color;
    }

    @Inject(method={"getTeamColorValue"}, at={@At(value="RETURN")}, cancellable=true)
    public void injectChangeColorValue(CallbackInfoReturnable<Integer> cir) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            ColoredGlowLibMod.LOGGER.warn("ERROR! THE PLAYER UUID IS NULL!");
        }
        class_1297 entity = (class_1297)this;
        ColoredGlowLibAPI cgl = ColoredGlowLibMod.getAPI();
        if (cgl == null) {
            ColoredGlowLibMod.LOGGER.warn("The ColoredGlowLib API instance is null! Trying to reinitialize it!");
            ColoredGlowLibMod.TRIES_BEFORE_SHUTDOWN = (short)(ColoredGlowLibMod.TRIES_BEFORE_SHUTDOWN + 1);
            ColoredGlowLibMod.reInitAPIInstance(entity.method_37908().method_8428());
            if (ColoredGlowLibMod.TRIES_BEFORE_SHUTDOWN >= 5) {
                ColoredGlowLibMod.LOGGER.error("Disabling the mod, can't get the API instance to work!");
            }
            if ((cgl = ColoredGlowLibMod.getAPI()) == null) {
                return;
            }
        }
        if (entity == null) {
            ColoredGlowLibMod.LOGGER.warn("The entity is null! Can't display the custom color!");
            return;
        }
        if (entity.method_5781() == null || cgl.getOverrideTeamColors()) {
            if (ColoredGlowLibMod.isAp1) {
                cir.setReturnValue((Object)ColorUtils.toColorValue(255, 0, 174));
                return;
            }
            if (entity.method_5477().getString().equalsIgnoreCase("jeb_")) {
                cir.setReturnValue((Object)this.getRainbowColor());
                return;
            }
            if (cgl.getDefaultOverridesAll()) {
                String color = cgl.getGlobalColor();
                if (color.equalsIgnoreCase("rainbow")) {
                    cir.setReturnValue((Object)this.getRainbowColor());
                    return;
                }
                if (color.equalsIgnoreCase("random")) {
                    cir.setReturnValue((Object)this.randomColor());
                    return;
                }
                int custom = this.handleCustomColor(color);
                if (custom != -1) {
                    cir.setReturnValue((Object)custom);
                    return;
                }
                cir.setReturnValue((Object)ColorUtils.toColorValue(color));
                return;
            }
            if (cgl.getEntityTypeColorOverridesEntityColor()) {
                String color = cgl.getColor(entity.method_5864());
                if (color.equalsIgnoreCase("rainbow")) {
                    cir.setReturnValue((Object)this.getRainbowColor());
                    return;
                }
                if (color.equalsIgnoreCase("random")) {
                    cir.setReturnValue((Object)this.randomColor());
                    return;
                }
                int custom = this.handleCustomColor(color);
                if (custom != -1) {
                    cir.setReturnValue((Object)custom);
                    return;
                }
                cir.setReturnValue((Object)ColorUtils.toColorValue(cgl.getColor(entity.method_5864())));
                return;
            }
            String entity_col = cgl.getColor(entity);
            if (ColoredGlowLibMod.getAPI() != null && ColoredGlowLibMod.getAPI().hasExclusiveCustomOrDefaultColorFor(entity, (class_1657)Objects.requireNonNull(player))) {
                String exclusiveColor = ColoredGlowLibMod.getAPI().getExclusiveColorFor(entity, (class_1657)player);
                if (exclusiveColor.equalsIgnoreCase("rainbow")) {
                    cir.setReturnValue((Object)this.getRainbowColor());
                    return;
                }
                if (exclusiveColor.equalsIgnoreCase("random")) {
                    cir.setReturnValue((Object)this.randomColor());
                    return;
                }
                int custom = this.handleCustomColor(exclusiveColor);
                if (custom != -1) {
                    cir.setReturnValue((Object)custom);
                    return;
                }
                cir.setReturnValue((Object)ColorUtils.toColorValue(exclusiveColor));
                return;
            }
            if (ColoredGlowLibMod.getAPI() != null && !ColoredGlowLibMod.getAPI().hasCustomColor(entity)) {
                String type_col = cgl.getColor(entity.method_5864());
                if (ColoredGlowLibMod.getAPI().hasCustomColor(entity.method_5864())) {
                    if (type_col.equalsIgnoreCase("rainbow")) {
                        cir.setReturnValue((Object)this.getRainbowColor());
                        return;
                    }
                    if (type_col.equalsIgnoreCase("random")) {
                        cir.setReturnValue((Object)this.randomColor());
                        return;
                    }
                    int custom = this.handleCustomColor(type_col);
                    if (custom != -1) {
                        cir.setReturnValue((Object)custom);
                        return;
                    }
                    cir.setReturnValue((Object)ColorUtils.toColorValue(type_col));
                    return;
                }
                if (cgl.getGlobalColor().equalsIgnoreCase("rainbow")) {
                    cir.setReturnValue((Object)this.getRainbowColor());
                    return;
                }
                if (cgl.getDefaultColor().equalsIgnoreCase("random")) {
                    cir.setReturnValue((Object)this.randomColor());
                    return;
                }
                int custom = this.handleCustomColor(cgl.getDefaultColor());
                if (custom != -1) {
                    cir.setReturnValue((Object)custom);
                    return;
                }
                cir.setReturnValue((Object)ColorUtils.toColorValue(cgl.getDefaultColor()));
                return;
            }
            if (entity_col.equalsIgnoreCase("rainbow")) {
                cir.setReturnValue((Object)this.getRainbowColor());
                return;
            }
            if (entity_col.equalsIgnoreCase("random")) {
                cir.setReturnValue((Object)this.randomColor());
                return;
            }
            int custom = this.handleCustomColor(entity_col);
            if (custom != -1) {
                cir.setReturnValue((Object)custom);
                return;
            }
            cir.setReturnValue((Object)ColorUtils.toColorValue(entity_col));
        }
    }
}

