/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib.custom_data_animations;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;
import me.emafire003.dev.coloredglowlib.networking.ColorAnimationPacketS2C;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class CGLResourceManager {
    public static String RESOURCE_PATH = "color_animations";

    public static void register() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return ColoredGlowLibMod.getIdentifier(RESOURCE_PATH);
            }

            public void method_14491(class_3300 manager) {
                ColoredGlowLibMod.getCustomColorAnimations().clear();
                Map resources = manager.method_14488(RESOURCE_PATH, identifier -> identifier.method_12832().endsWith(".json"));
                for (class_2960 id : resources.keySet()) {
                    try {
                        BufferedReader reader = ((class_3298)resources.get(id)).method_43039();
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        DataResult result = CustomColorAnimation.CODEC.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement));
                        ColoredGlowLibMod.LOGGER.debug("Processing file: " + String.valueOf(id));
                        CustomColorAnimation groupOutput = (CustomColorAnimation)result.getOrThrow(false, arg_0 -> ((Logger)ColoredGlowLibMod.LOGGER).warn(arg_0));
                        ColoredGlowLibMod.loadCustomColorAnimation(groupOutput);
                    }
                    catch (Exception e) {
                        ColoredGlowLibMod.LOGGER.error("Error occurred while loading resource json" + id.toString(), (Throwable)e);
                    }
                }
                ColoredGlowLibMod.checkMaybeWrongAnimations();
                if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER)) {
                    @Nullable MinecraftServer server = ColoredGlowLibMod.getServerInstance();
                    if (server == null) {
                        return;
                    }
                    for (CustomColorAnimation animation : ColoredGlowLibMod.getCustomColorAnimations()) {
                        server.method_3760().method_14571().forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)ColorAnimationPacketS2C.ID, (class_2540)new ColorAnimationPacketS2C(animation)));
                    }
                }
            }
        });
    }
}

