/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib.component;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.ComponentV3;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GlobalColorComponent
implements ComponentV3,
AutoSyncedComponent {
    public static final ComponentKey<GlobalColorComponent> GLOBAL_COLOR_COMPONENT = ComponentRegistry.getOrCreate((class_2960)ColoredGlowLibMod.getIdentifier("global_color_component"), GlobalColorComponent.class);
    private final class_269 scoreboard;
    protected String default_color = "#ffffff";
    protected boolean typeOverridesEntityColor = false;
    protected boolean defaultOverridesAll = false;
    protected boolean overrideTeamColors = false;
    protected class_2487 entityTypeColorMap = new class_2487();

    public GlobalColorComponent(class_269 scoreboard, @Nullable MinecraftServer server) {
        this.scoreboard = scoreboard;
    }

    public void readFromNbt(class_2487 tag) {
        this.default_color = tag.method_10545("defaultColor") ? tag.method_10558("defaultColor") : "#ffffff";
        this.typeOverridesEntityColor = tag.method_10545("typeOverridesEntityColor") ? tag.method_10577("typeOverridesEntityColor") : false;
        this.defaultOverridesAll = tag.method_10545("defaultOverridesAll") ? tag.method_10577("defaultOverridesAll") : false;
        this.overrideTeamColors = tag.method_10545("overrideTeamColors") ? tag.method_10577("overrideTeamColors") : false;
        this.entityTypeColorMap = tag.method_10545("entityTypeColorMap") ? tag.method_10562("entityTypeColorMap") : new class_2487();
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10582("defaultColor", this.default_color);
        tag.method_10556("typeOverridesEntityColor", this.typeOverridesEntityColor);
        tag.method_10556("defaultOverridesAll", this.defaultOverridesAll);
        tag.method_10556("overrideTeamColors", this.overrideTeamColors);
        tag.method_10566("entityTypeColorMap", (class_2520)this.entityTypeColorMap);
    }

    public HashMap<class_1299<?>, String> getEntityTypeColorMap() {
        HashMap map = new HashMap();
        ArrayList keys = new ArrayList(this.entityTypeColorMap.method_10541());
        keys.forEach(key -> {
            Optional type = class_1299.method_5898((String)key);
            String color = this.entityTypeColorMap.method_10558(key);
            type.ifPresent(entityType -> map.put((class_1299<?>)entityType, color));
        });
        return map;
    }

    public void addEntityTypeColor(class_1299<?> type, String color) {
        this.entityTypeColorMap.method_10582(type.toString(), color);
        GLOBAL_COLOR_COMPONENT.sync((Object)this.scoreboard);
    }

    public void setEntityTypeColor(class_1299<?> type, String color) {
        if (this.entityTypeColorMap.method_10545(type.toString())) {
            this.entityTypeColorMap.method_10551(type.toString());
        }
        this.addEntityTypeColor(type, color);
    }

    public void clearEntityTypeColor(class_1299<?> type) {
        this.entityTypeColorMap.method_10551(type.toString());
        GLOBAL_COLOR_COMPONENT.sync((Object)this.scoreboard);
    }

    public String getEntityTypeColor(class_1299<?> type) {
        String color = this.entityTypeColorMap.method_10558(type.toString());
        if (color == null || color.equalsIgnoreCase("")) {
            return "#ffffff";
        }
        return this.entityTypeColorMap.method_10558(type.toString());
    }

    public String getDefaultColor() {
        return this.default_color;
    }

    public void setDefaultColor(String default_color) {
        this.default_color = default_color;
        GLOBAL_COLOR_COMPONENT.sync((Object)this.scoreboard);
    }

    public boolean getEntityTypeOverridesEntityColor() {
        return this.typeOverridesEntityColor;
    }

    public void setTypeOverridesEntityColor(boolean b) {
        this.typeOverridesEntityColor = b;
        GLOBAL_COLOR_COMPONENT.sync((Object)this.scoreboard);
    }

    public boolean getDefaultOverridesAll() {
        return this.defaultOverridesAll;
    }

    public void setDefaultOverridesAll(boolean b) {
        this.defaultOverridesAll = b;
        GLOBAL_COLOR_COMPONENT.sync((Object)this.scoreboard);
    }

    public boolean getOverrideTeamColors() {
        return this.overrideTeamColors;
    }

    public void setOverrideTeamColors(boolean b) {
        this.overrideTeamColors = b;
        GLOBAL_COLOR_COMPONENT.sync((Object)this.scoreboard);
    }

    public void clear() {
        this.default_color = "#ffffff";
        this.typeOverridesEntityColor = false;
        this.defaultOverridesAll = false;
        this.overrideTeamColors = false;
        this.entityTypeColorMap = new class_2487();
        GLOBAL_COLOR_COMPONENT.sync((Object)this.scoreboard);
    }
}

