/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib;

import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.scoreboard.ScoreboardComponentInitializer;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.List;
import me.emafire003.dev.coloredglowlib.ColoredGlowLibAPI;
import me.emafire003.dev.coloredglowlib.command.CGLCommands;
import me.emafire003.dev.coloredglowlib.component.ColorComponent;
import me.emafire003.dev.coloredglowlib.component.GlobalColorComponent;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CGLResourceManager;
import me.emafire003.dev.coloredglowlib.custom_data_animations.ColorAnimationItem;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;
import me.emafire003.dev.coloredglowlib.networking.ColorAnimationPacketS2C;
import me.emafire003.dev.coloredglowlib.networking.PlayerJoinEvent;
import me.emafire003.dev.coloredglowlib.util.ColorUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColoredGlowLibMod
implements ModInitializer,
EntityComponentInitializer,
ScoreboardComponentInitializer {
    public static String MOD_ID = "coloredglowlib";
    public static Logger LOGGER = LoggerFactory.getLogger((String)MOD_ID);
    public static String PREFIX = "\u00a7f[\u00a7cC\u00a76o\u00a7el\u00a7ao\u00a73r\u00a79e\u00a75d\u00a7cG\u00a76l\u00a7eo\u00a7aw\u00a73L\u00a79i\u00a75b\u00a7f] \u00a77";
    private static ColoredGlowLibAPI coloredGlowLib;
    public static boolean isAp1;
    public static short TRIES_BEFORE_SHUTDOWN;
    public static final short MAX_TRIES = 5;
    public static final boolean SHUTDOWN = false;
    private static MinecraftServer mcserver;
    private static final List<CustomColorAnimation> custom_color_animations;
    private static final List<CustomColorAnimation> maybe_wrong_color_animations;

    public void onInitialize() {
        LOGGER.info("Initializing...");
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            coloredGlowLib = new ColoredGlowLibAPI((class_269)server.method_3845());
            mcserver = server;
        });
        LocalDate currentDate = LocalDate.now();
        int day = currentDate.getDayOfMonth();
        Month month = currentDate.getMonth();
        if (month.equals(Month.APRIL) && day == 1) {
            isAp1 = true;
        }
        CGLResourceManager.register();
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER)) {
            PlayerJoinEvent.EVENT.register((player, server) -> {
                for (CustomColorAnimation animation : ColoredGlowLibMod.getCustomColorAnimations()) {
                    ServerPlayNetworking.send((class_3222)player, (class_2960)ColorAnimationPacketS2C.ID, (class_2540)new ColorAnimationPacketS2C(animation));
                }
                return class_1269.field_5811;
            });
        }
        CommandRegistrationCallback.EVENT.register(CGLCommands::registerCommands);
        LOGGER.info("Complete!");
    }

    public static void reInitAPIInstance(class_269 scoreboard) {
        coloredGlowLib = new ColoredGlowLibAPI(scoreboard);
    }

    public static class_2960 getIdentifier(String path) {
        return class_2960.method_43902((String)MOD_ID, (String)path);
    }

    @Nullable
    public static MinecraftServer getServerInstance() {
        return mcserver;
    }

    @Nullable
    public static ColoredGlowLibAPI getAPI() {
        return coloredGlowLib;
    }

    @Nullable
    public static ColoredGlowLibAPI getColoredGlowLib() {
        return coloredGlowLib;
    }

    @Nullable
    public static ColoredGlowLibAPI getLib() {
        return coloredGlowLib;
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(ColorComponent.COLOR_COMPONENT, ColorComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
        registry.registerFor(class_1297.class, ColorComponent.COLOR_COMPONENT, ColorComponent::new);
    }

    public void registerScoreboardComponentFactories(ScoreboardComponentFactoryRegistry registry) {
        registry.registerScoreboardComponent(GlobalColorComponent.GLOBAL_COLOR_COMPONENT, GlobalColorComponent::new);
    }

    public static boolean loadCustomColorAnimation(CustomColorAnimation animation) {
        for (CustomColorAnimation customColorAnimation : custom_color_animations) {
            if (!animation.getName().equalsIgnoreCase(customColorAnimation.getName())) continue;
            LOGGER.warn("The color animation '" + animation.getName() + "' wasn't loaded because there already is an animation with that name!!");
            return false;
        }
        for (ColorAnimationItem color_item : animation.getColorAnimations()) {
            if (color_item.getColor().equalsIgnoreCase(animation.getName())) {
                LOGGER.error("The color animation '" + animation.getName() + "' wasn't loaded because you can't set a color to be the same as the name of the animation");
                return false;
            }
            if (ColorUtils.isValidColorOrCustom(color_item.getColor())) continue;
            maybe_wrong_color_animations.add(animation);
            LOGGER.warn("The color animation '" + animation.getName() + "' wasn't loaded yet because '" + color_item.getColor() + "' isn't a valid color! Maybe it's a custom animation processed later, flagging this for a later check!");
            return false;
        }
        custom_color_animations.add(animation);
        LOGGER.info("The custom color animation '" + animation.getName() + "' was loaded successfully!");
        return true;
    }

    public static void checkMaybeWrongAnimations() {
        for (CustomColorAnimation animation : maybe_wrong_color_animations) {
            boolean should_add = true;
            for (ColorAnimationItem color_item : animation.getColorAnimations()) {
                if (ColorUtils.isValidColorOrCustom(color_item.getColor())) continue;
                LOGGER.error("The color animation '" + animation.getName() + "' wasn't loaded because '" + color_item.getColor() + "' isn't a valid color! Use #RRGGBB or 'rainbow' or 'random' or another color animation name!");
                should_add = false;
                break;
            }
            if (!should_add) continue;
            custom_color_animations.add(animation);
            LOGGER.info("The custom color animation '" + animation.getName() + "' was loaded successfully!");
        }
        maybe_wrong_color_animations.clear();
    }

    public static List<CustomColorAnimation> getCustomColorAnimations() {
        return custom_color_animations;
    }

    static {
        isAp1 = false;
        TRIES_BEFORE_SHUTDOWN = 0;
        mcserver = null;
        custom_color_animations = new ArrayList<CustomColorAnimation>();
        maybe_wrong_color_animations = new ArrayList<CustomColorAnimation>();
    }
}

