/*
 * Decompiled with CFR 0.152.
 */
package me.emafire003.dev.coloredglowlib;

import me.emafire003.dev.coloredglowlib.ColoredGlowLibMod;
import me.emafire003.dev.coloredglowlib.component.ColorComponent;
import me.emafire003.dev.coloredglowlib.component.GlobalColorComponent;
import me.emafire003.dev.coloredglowlib.custom_data_animations.CustomColorAnimation;
import me.emafire003.dev.coloredglowlib.util.ColorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_269;

public class ColoredGlowLibAPI {
    private final GlobalColorComponent globalColorComponent;

    public ColoredGlowLibAPI(class_269 scoreboard) {
        this.globalColorComponent = (GlobalColorComponent)GlobalColorComponent.GLOBAL_COLOR_COMPONENT.get((Object)scoreboard);
    }

    public void setOverrideTeamColors(boolean b) {
        this.globalColorComponent.setOverrideTeamColors(b);
    }

    public boolean getOverrideTeamColors() {
        return this.globalColorComponent.getOverrideTeamColors();
    }

    public void setDefaultOverridesAll(boolean b) {
        this.globalColorComponent.setDefaultOverridesAll(b);
    }

    public boolean getDefaultOverridesAll() {
        return this.globalColorComponent.getDefaultOverridesAll();
    }

    public void setEntityTypeColorOverridesEntityColor(boolean b) {
        this.globalColorComponent.setTypeOverridesEntityColor(b);
    }

    public boolean getEntityTypeColorOverridesEntityColor() {
        return this.globalColorComponent.getEntityTypeOverridesEntityColor();
    }

    public void setGlobalColor(String color) {
        this.globalColorComponent.setDefaultColor(color);
    }

    public void setGlobalRainbow() {
        this.setGlobalColor("rainbow");
    }

    public void setGlobalRandom() {
        this.setGlobalColor("random");
    }

    public void setDefaultColor(String color) {
        this.setGlobalColor(color);
    }

    public void clearGlobalColor() {
        this.globalColorComponent.setDefaultColor("#ffffff");
    }

    public void setColor(class_1297 target, String color) {
        ColorComponent component = (ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target);
        component.setColor(color);
    }

    public void setColor(class_1299<?> target, String color) {
        this.globalColorComponent.setEntityTypeColor(target, color);
    }

    public void setRainbowColor(class_1297 target) {
        this.setColor(target, "rainbow");
    }

    public void setRandomColor(class_1297 target) {
        this.setColor(target, "random");
    }

    public void setRainbowColor(class_1299<?> target) {
        this.setColor(target, "rainbow");
    }

    public void setRandomColor(class_1299<?> target) {
        this.setColor(target, "random");
    }

    public void clearColor(class_1297 entity, boolean useDefaultColorInstead) {
        ColorComponent component = (ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)entity);
        if (useDefaultColorInstead) {
            component.setColor(this.globalColorComponent.getDefaultColor());
            return;
        }
        component.clear();
    }

    public void clearColor(class_1299<?> entityType, boolean useDefaultColorInstead) {
        if (useDefaultColorInstead) {
            this.globalColorComponent.setEntityTypeColor(entityType, this.globalColorComponent.getDefaultColor());
            return;
        }
        this.globalColorComponent.clearEntityTypeColor(entityType);
    }

    public String getColor(class_1297 target) {
        return ((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getColor();
    }

    public String getColor(class_1299<?> target) {
        return this.globalColorComponent.getEntityTypeColor(target);
    }

    public String getGlobalColor() {
        return this.globalColorComponent.getDefaultColor();
    }

    public String getDefaultColor() {
        return this.globalColorComponent.getDefaultColor();
    }

    public boolean hasCustomColor(class_1299<?> target) {
        return !ColorUtils.checkDefault(this.globalColorComponent.getEntityTypeColor(target));
    }

    public boolean hasCustomOrDefaultColor(class_1299<?> target) {
        return !ColorUtils.checkDefault(this.globalColorComponent.getEntityTypeColor(target)) && !ColorUtils.checkSameColor(this.globalColorComponent.getEntityTypeColor(target), this.globalColorComponent.getDefaultColor());
    }

    public boolean hasCustomColor(class_1297 target) {
        return !ColorUtils.checkDefault(((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getColor());
    }

    public boolean hasCustomOrDefaultColor(class_1297 target) {
        return !ColorUtils.checkDefault(((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getColor()) && !ColorUtils.checkSameColor(((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getColor(), this.globalColorComponent.getDefaultColor());
    }

    public boolean hasRainbowColor(class_1299<?> target) {
        return this.globalColorComponent.getEntityTypeColor(target).equalsIgnoreCase("rainbow");
    }

    public boolean hasRandomColor(class_1299<?> target) {
        return this.globalColorComponent.getEntityTypeColor(target).equalsIgnoreCase("random");
    }

    public boolean hasRainbowColor(class_1297 target) {
        return ((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getColor().equalsIgnoreCase("rainbow");
    }

    public boolean hasRandomColor(class_1297 target) {
        return ((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getColor().equalsIgnoreCase("random");
    }

    public boolean hasCustomColorAnimation(class_1299<?> target) {
        String target_color = this.globalColorComponent.getEntityTypeColor(target);
        for (CustomColorAnimation animation : ColoredGlowLibMod.getCustomColorAnimations()) {
            if (!target_color.equalsIgnoreCase(animation.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomColorAnimation(class_1297 target) {
        String color = ((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getColor();
        for (CustomColorAnimation customColorAnimation : ColoredGlowLibMod.getCustomColorAnimations()) {
            if (!color.equalsIgnoreCase(customColorAnimation.getName())) continue;
            return true;
        }
        return false;
    }

    public void setExclusiveColorFor(class_1297 target, String color, class_1657 colorViewer) {
        ColorComponent component = (ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target);
        component.setExclusiveColorFor(colorViewer.method_5667(), color);
    }

    public void clearExclusiveColorFor(class_1297 entity, class_1657 colorViewer, boolean useDefaultColorInstead) {
        ColorComponent component = (ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)entity);
        if (useDefaultColorInstead) {
            component.setExclusiveColorFor(colorViewer.method_5667(), this.globalColorComponent.getDefaultColor());
            return;
        }
        component.clearExclusiveColorFor(colorViewer.method_5667());
    }

    public String getExclusiveColorFor(class_1297 target, class_1657 colorViewer) {
        return ((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getExclusiveColorFor(colorViewer.method_5667());
    }

    public boolean hasExclusiveCustomColorFor(class_1297 target, class_1657 colorViewer) {
        return !ColorUtils.checkDefault(((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getExclusiveColorFor(colorViewer.method_5667()));
    }

    public boolean hasExclusiveCustomOrDefaultColorFor(class_1297 target, class_1657 colorViewer) {
        return !ColorUtils.checkDefault(((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getExclusiveColorFor(colorViewer.method_5667())) && !ColorUtils.checkSameColor(((ColorComponent)ColorComponent.COLOR_COMPONENT.get((Object)target)).getExclusiveColorFor(colorViewer.method_5667()), this.globalColorComponent.getDefaultColor());
    }
}

