/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.RenderableText;
import dev.cheos.armorpointspp.core.Side;
import dev.cheos.armorpointspp.core.Suffix;
import dev.cheos.armorpointspp.core.adapter.IConfig;

public class ToughnessTextComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        int power;
        if (!(ctx.shouldRenderToughness() && ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_ENABLE) && ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_BAR) && ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_TEXT_ENABLE))) {
            return false;
        }
        ctx.profiler.push("toughnessText");
        double toughness = ctx.data.toughness();
        Suffix.Type type = ctx.config.enm(IConfig.EnumOption.SUFFIX);
        int n = power = toughness == 0.0 ? 0 : (int)Math.log10(toughness);
        if (type != Suffix.Type.SCI && power < 27) {
            power = power / 3 * 3;
        } else {
            type = Suffix.Type.SCI;
        }
        Object significand = String.valueOf((float)ctx.math.floor(toughness / Math.pow(10.0, power) * 10.0) / 10.0f);
        if (((String)significand).endsWith(".0")) {
            significand = ((String)significand).substring(0, ((String)significand).length() - 2);
        }
        significand = (String)significand + (String)(type == Suffix.Type.SCI ? "E" + power : Suffix.byPow(power).getSuffix(type));
        int color = ctx.config.hex(IConfig.HexOption.TEXT_COLOR_TOUGHNESS);
        Side side = ctx.config.enm(IConfig.EnumOption.TOUGHNESS_SIDE);
        if (ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_TEXT_CONFIG_ENABLE)) {
            new RenderableText((String)significand).withAlignment(ctx.config.enm(IConfig.EnumOption.TOUGHNESS_TEXT_ALIGNMENT)).withColor(color).withShadow(ctx.config.bool(IConfig.BooleanOption.TEXT_SHADOW)).render(ctx.poseStack, ctx.renderer, ctx.config.dec(IConfig.FloatOption.TOUGHNESS_TEXT_X), ctx.config.dec(IConfig.FloatOption.TOUGHNESS_TEXT_Y));
        } else {
            new RenderableText((String)significand).withAlignment(side.preferredAlignment()).withColor(color).withShadow(ctx.config.bool(IConfig.BooleanOption.TEXT_SHADOW)).render(ctx.poseStack, ctx.renderer, ctx.x + (side == Side.RIGHT ? 83 : -1), (float)ctx.y + 0.5f);
        }
        return this.popReturn(ctx, true);
    }
}

