/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;

public class ToughnessOverlayComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!ctx.shouldRenderArmor() || !ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_ENABLE) || ctx.config.bool(IConfig.BooleanOption.TOUGHNESS_BAR) || ctx.config.bool(IConfig.BooleanOption.ARMOR_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("toughness");
        double toughness = (int)ctx.data.toughness();
        toughness = ctx.math.ceil(toughness * (double)ctx.config.dec(IConfig.FloatOption.TOUGHNESS_VALUE));
        if (toughness <= 0.0) {
            return this.popReturn(ctx, false);
        }
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        for (int i = 0; i < 10 && (double)i < toughness; ++i) {
            tex.drawToughness(ctx, ctx.x + 8 * i, ctx.y, (int)((toughness - (double)i - 1.0) * (double)0.1f), false, true, false);
        }
        return this.popReturn(ctx, true);
    }
}

