/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.adapter.IItemStack;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;

public class ProtectionComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!ctx.shouldRenderArmor() || !ctx.config.bool(IConfig.BooleanOption.PROTECTION_ENABLE) || ctx.config.bool(IConfig.BooleanOption.ARMOR_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("protection");
        int protection = 0;
        for (IItemStack stack : ctx.data.armorSlots()) {
            ctx.ench.getLevel(ctx.data.enchantments().protection(), stack);
            protection += ctx.ench.getLevel(ctx.data.enchantments().protection(), stack);
            protection += ctx.ench.getLevel(ctx.data.enchantments().blastProtection(), stack);
            protection += ctx.ench.getLevel(ctx.data.enchantments().fireProtection(), stack);
            protection += ctx.ench.getLevel(ctx.data.enchantments().projectileProtection(), stack);
        }
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        protection = ctx.math.ceil((float)protection * ctx.config.dec(IConfig.FloatOption.PROTECTION_VALUE));
        if ((protection = ctx.math.clamp(protection, 0, 10)) <= 0) {
            return this.popReturn(ctx, false);
        }
        for (int i = 0; i < 10 && i < protection; ++i) {
            tex.drawOverlay(ctx, ctx.x + 8 * i, ctx.y, false, false, ITextureSheet.OverlaySprite.PROTECTION);
        }
        return this.popReturn(ctx, true);
    }
}

