/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;
import java.util.Random;

public class HealthComponent
implements IRenderComponent {
    private final Random random = new Random();
    private int lastHealth;
    private int displayHealth;
    private int lastGuiTicks;
    private long healthBlinkTime;
    private long lastHealthTime;
    private int[] lastHeartY = new int[10];

    @Override
    public boolean render(RenderContext ctx) {
        int max;
        ITextureSheet.HeartStyle style;
        int regen;
        if (!ctx.shouldRender() || !ctx.config.bool(IConfig.BooleanOption.HEALTH_ENABLE) || ctx.config.bool(IConfig.BooleanOption.HEALTH_HIDDEN)) {
            return false;
        }
        ctx.profiler.push("health");
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        boolean frozen = ctx.data.isFullyFrozen();
        boolean hardcore = ctx.data.isHardcore() || ctx.data.isEffectActive("spectrum:divinity");
        boolean absorbOv = ctx.data.absorption() > 0.0f && ctx.config.bool(IConfig.BooleanOption.ABSORPTION_ENABLE) && ctx.config.bool(IConfig.BooleanOption.ABSORPTION_OVERLAY);
        int health = ctx.math.ceil(ctx.data.health());
        int heartStack = Math.min((health - 1) / 20, 10);
        this.lastGuiTicks = ctx.data.guiTicks();
        boolean blink = !frozen && this.healthBlinkTime > (long)this.lastGuiTicks && (this.healthBlinkTime - (long)this.lastGuiTicks) / 3L % 2L == 1L;
        int n = regen = ctx.data.isEffectActive(ctx.data.effects().regeneration()) ? this.lastGuiTicks % 25 : -1;
        ITextureSheet.HeartStyle heartStyle = ctx.data.isEffectActive(ctx.data.effects().poison()) ? ITextureSheet.HeartStyle.POISON : (style = ctx.data.isEffectActive(ctx.data.effects().wither()) ? ITextureSheet.HeartStyle.WITHER : ITextureSheet.HeartStyle.NORMAL);
        if (health < this.lastHealth && ctx.data.invulnTime() > 0) {
            this.lastHealthTime = ctx.data.millis();
            this.healthBlinkTime = this.lastGuiTicks + 20;
        } else if (health > this.lastHealth && ctx.data.invulnTime() > 0) {
            this.lastHealthTime = ctx.data.millis();
            this.healthBlinkTime = this.lastGuiTicks + 10;
        }
        if (ctx.data.millis() - this.lastHealthTime > 1000L) {
            this.displayHealth = health;
            this.lastHealthTime = ctx.data.millis();
        }
        this.lastHealth = health;
        this.random.setSeed((long)this.lastGuiTicks * 312871L);
        block4: for (int i = max = ctx.config.bool(IConfig.BooleanOption.HEALTH_BG_ALWAYS_SHOW_10) ? 9 : (int)Math.min(10.0f, (ctx.data.maxHealth() + 1.0f) * 0.5f) - 1; i >= 0; --i) {
            int heartX = ctx.x + i * 8;
            int heartY = ctx.y;
            int heartValue = i * 2 + heartStack * 20 + 1;
            if (health <= 4) {
                heartY += this.random.nextInt(2);
            }
            if (i == regen && !frozen) {
                heartY -= 2;
            }
            this.lastHeartY[i] = heartY;
            tex.drawHeartBG(ctx, heartX, heartY, blink);
            if (heartValue >= health && heartStack > 0) {
                tex.drawHeart(ctx, heartX, heartY, heartStack - 1, false, blink, hardcore, style);
            }
            if (blink && heartValue <= this.displayHealth) {
                tex.drawHeart(ctx, heartX, heartY, heartStack, heartValue == this.displayHealth, true, hardcore, style);
            }
            if (heartValue <= health) {
                tex.drawHeart(ctx, heartX, heartY, heartStack, heartValue == health, false, hardcore, style);
            }
            if (!frozen || absorbOv) continue;
            switch (ctx.config.enm(IConfig.EnumOption.FROSTBITE_STYLE)) {
                case FULL: {
                    if (heartValue > health) continue block4;
                    tex.drawOverlay(ctx, heartX, heartY, heartValue == health, hardcore, ITextureSheet.OverlaySprite.FROSTBITE_FULL);
                    continue block4;
                }
                case OVERLAY: {
                    if (heartValue > health) continue block4;
                    tex.drawOverlay(ctx, heartX, heartY, heartValue == health, hardcore, ITextureSheet.OverlaySprite.FROSTBITE);
                    continue block4;
                }
                default: {
                    if (heartValue >= health) continue block4;
                    tex.drawOverlay(ctx, heartX, heartY, false, hardcore, ITextureSheet.OverlaySprite.FROSTBITE_ICON);
                }
            }
        }
        return this.popReturn(ctx, true);
    }

    public int[] lastHeartY() {
        return this.lastHeartY;
    }

    int lastGuiTicks() {
        return this.lastGuiTicks;
    }

    long healthBlinkTime() {
        return this.healthBlinkTime;
    }
}

