/*
 * Decompiled with CFR 0.152.
 */
package dev.cheos.armorpointspp.core.render;

import dev.cheos.armorpointspp.core.IRenderComponent;
import dev.cheos.armorpointspp.core.RenderContext;
import dev.cheos.armorpointspp.core.adapter.IConfig;
import dev.cheos.armorpointspp.core.render.Components;
import dev.cheos.armorpointspp.core.texture.ITextureSheet;

public class AbsorptionOverlayComponent
implements IRenderComponent {
    @Override
    public boolean render(RenderContext ctx) {
        if (!(ctx.shouldRender() && ctx.config.bool(IConfig.BooleanOption.ABSORPTION_ENABLE) && ctx.config.bool(IConfig.BooleanOption.HEALTH_ENABLE) && ctx.config.bool(IConfig.BooleanOption.ABSORPTION_OVERLAY) && !ctx.config.bool(IConfig.BooleanOption.HEALTH_HIDDEN))) {
            return false;
        }
        ctx.profiler.push("absorption");
        ITextureSheet tex = this.tex(ctx).bind(ctx);
        boolean frozen = ctx.data.isFullyFrozen();
        boolean hardcore = ctx.data.isHardcore() || ctx.data.isEffectActive("spectrum:divinity");
        int health = ctx.math.ceil(ctx.data.health());
        int heartStack = (health - 1) / 20;
        int absorb = ctx.math.ceil(ctx.data.absorption());
        int totalHealth = health + absorb;
        if (absorb <= 0) {
            return this.popReturn(ctx, false);
        }
        block4: for (int i = 0; i <= 9; ++i) {
            int heartX = ctx.x + i * 8;
            int heartY = Components.HEALTH.lastHeartY()[i];
            int heartValue = i * 2 + heartStack * 20 + 1;
            int heartValueA = heartValue + 20;
            if (absorb >= 20) {
                tex.drawAbsorbHeart(ctx, heartX, heartY, false, false, hardcore);
            } else if (heartValueA <= totalHealth) {
                tex.drawAbsorbHeart(ctx, heartX, heartY, heartValueA == totalHealth, false, hardcore);
            } else if (heartValue == health) {
                tex.drawAbsorbHeart(ctx, heartX + 5, heartY, true, true, hardcore);
            } else if (heartValue < totalHealth && heartValue > health) {
                tex.drawAbsorbHeart(ctx, heartX, heartY, false, false, hardcore);
            } else if (heartValue == totalHealth) {
                tex.drawAbsorbHeart(ctx, heartX, heartY, true, false, hardcore);
            }
            if (!frozen) continue;
            switch (ctx.config.enm(IConfig.EnumOption.FROSTBITE_STYLE)) {
                case FULL: {
                    if (heartValue > totalHealth) continue block4;
                    tex.drawOverlay(ctx, heartX, heartY, heartValue == totalHealth, hardcore, ITextureSheet.OverlaySprite.FROSTBITE_FULL);
                    continue block4;
                }
                case OVERLAY: {
                    if (heartValue > totalHealth) continue block4;
                    tex.drawOverlay(ctx, heartX, heartY, heartValue == totalHealth, hardcore, ITextureSheet.OverlaySprite.FROSTBITE);
                    continue block4;
                }
                default: {
                    if (heartValue >= totalHealth) continue block4;
                    tex.drawOverlay(ctx, heartX, heartY, false, hardcore, ITextureSheet.OverlaySprite.FROSTBITE_ICON);
                }
            }
        }
        return this.popReturn(ctx, true);
    }
}

