/*
 * Decompiled with CFR 0.152.
 */
package com.briknex.fathomless.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Double> EVENT_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> COOLDOWN_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Boolean> HALLUCINATION_ENABLE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> UNDAUNT_ENABLE;
    public static final ForgeConfigSpec.ConfigValue<Double> UNDAUNT_DESPAWN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> UNDAUNT_SONIC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> UNDAUNT_TELEPORT;
    public static final ForgeConfigSpec.ConfigValue<Double> UNDAUNT_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DEVOTED_MUSIC;
    public static final ForgeConfigSpec.ConfigValue<Double> ARCHBISHOP_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> FACELESS_ENABLE;
    public static final ForgeConfigSpec.ConfigValue<Double> ACCURSED_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> CULT_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> SCARLET_DAMAGE;

    static {
        BUILDER.push("Events");
        EVENT_MULTIPLIER = BUILDER.comment("Multiplies the event chance by the value's amount.").define("Event Chance Multiplier", (Object)1.5);
        COOLDOWN_MULTIPLIER = BUILDER.comment("Multiplies the cooldown placed on the Undaunted when an event occurs.").define("Cooldown Multiplier", (Object)1.0);
        HALLUCINATION_ENABLE = BUILDER.comment("Are you annoyed of hallucinations? Set this value to true in order to disable them entirely! Beware, Hallucinations are one of the main ways to lower accumilated chance.").define("Hallucinations", true);
        BUILDER.pop();
        BUILDER.push("Enemies");
        BUILDER.push("Undaunted");
        UNDAUNT_ENABLE = BUILDER.comment("Whether or not the Undaunted can spawn. (please dont turn this off)").define("Undaunted Spawning", true);
        UNDAUNT_DESPAWN = BUILDER.comment("How long it takes for the Undaunted to despawn (In Ticks, for example, 20 ticks is 1 second)").define("Undaunted Despawn Timer", (Object)1200.0);
        UNDAUNT_SONIC = BUILDER.comment("Is the Undaunted allowed to use its Sonic Boom? (Default: true)").define("Sonic Boom", true);
        UNDAUNT_TELEPORT = BUILDER.comment("Is the Undaunted allowed to use Teleportation?").define("Teleportation", true);
        BUILDER.push("Attributes");
        UNDAUNT_DAMAGE = BUILDER.comment("Multiplies the base damage by the value. Doesn't affect Breaker or Quad Combo. Default: 1").define("Undaunted Damage Multiplier", (Object)1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Devoted");
        DEVOTED_MUSIC = BUILDER.comment("Handles the Devoted's boss music. (Default: true)").define("Play Music", true);
        BUILDER.pop();
        BUILDER.push("Archbishop");
        BUILDER.push("Attributes");
        ARCHBISHOP_DAMAGE = BUILDER.comment("Multiplies the base damage by the value. Default: 1").define("Archbishop Damage Multiplier", (Object)1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Faceless");
        FACELESS_ENABLE = BUILDER.comment("Whether or not the Faceless is allowed to spawn normally. (Default: true)").define("Faceless Spawning", true);
        BUILDER.pop();
        BUILDER.push("Accursed");
        BUILDER.push("Attributes");
        ACCURSED_DAMAGE = BUILDER.comment("Multiplies the base damage by the value. Default: 1").define("Accursed Damage Multiplier", (Object)1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Cultists");
        BUILDER.push("Attributes");
        CULT_DAMAGE = BUILDER.comment("Multiplies the base damage by the value. Default: 1").define("Cult Member Damage Multipliers", (Object)1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("Scarlet Golem");
        BUILDER.push("Attributes");
        SCARLET_DAMAGE = BUILDER.comment("Multiplies the base damage by the value. Default: 1").define("Accursed Damage Multiplier", (Object)1.0);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

