/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Either;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicHolder<T>
implements Supplier<T>,
Holder<T> {
    private static final WeakHashSet<DynamicHolder<?>> REFERENCES = new WeakHashSet();
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;
    protected final ThreadLocal<Holder<T>> instance = new ThreadLocal();

    @ApiStatus.Internal
    public static void clearCache() {
        REFERENCES.forEach(DynamicHolder::invalidateInstance);
    }

    protected DynamicHolder(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
        this.registryKey = registryKey;
        this.key = key;
        REFERENCES.add(this);
    }

    public static <A> DynamicHolder<A> of(String id, ResourceKey<Registry<A>> registry) {
        return DynamicHolder.of(new ResourceLocation(id), registry);
    }

    public static <A> DynamicHolder<A> of(ResourceLocation location, ResourceKey<Registry<A>> registry) {
        return new DynamicHolder<A>(registry, ResourceKey.m_135785_(registry, (ResourceLocation)location));
    }

    public static <A> DynamicHolder<A> of(ResourceKey<A> key) {
        return new DynamicHolder<A>(ResourceKey.m_135788_((ResourceLocation)key.m_211136_()), key);
    }

    public static <A> Opt<A> optional(ResourceLocation location, ResourceKey<Registry<A>> registry) {
        return new Opt<A>(registry, ResourceKey.m_135785_(registry, (ResourceLocation)location));
    }

    public static <A> Opt<A> optional(ResourceKey<A> key) {
        return new Opt<A>(ResourceKey.m_135788_((ResourceLocation)key.m_211136_()), key);
    }

    public static <A> Opt<A> optional(String id, ResourceKey<Registry<A>> registry) {
        return DynamicHolder.optional(new ResourceLocation(id), registry);
    }

    private void invalidateInstance() {
        this.instance.remove();
    }

    @NotNull
    protected Holder<T> getInstance() {
        Holder.Reference value = this.instance.get();
        if (value == null) {
            RegistryAccess r = Utils.hackyGetRegistryAccess();
            Registry reg = r.m_175515_(this.registryKey);
            try {
                value = reg.m_246971_(this.key);
                this.instance.set((Holder<Holder.Reference>)value);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get object from registry: " + String.valueOf(this.key) + ".\nCalled from " + String.valueOf(Thread.currentThread()) + ".\nRegistry content was: " + String.valueOf(reg.m_6579_().stream().map(b -> ((ResourceKey)b.getKey()).m_135782_()).toList()), e);
            }
        }
        return value;
    }

    public String getRegisteredName() {
        return this.key.m_135782_().toString();
    }

    public ResourceLocation getID() {
        return this.key.m_135782_();
    }

    public ResourceKey<T> getKey() {
        return this.key;
    }

    @Override
    @Deprecated(forRemoval=true)
    @NotNull
    public T get() {
        return this.m_203334_();
    }

    public T m_203334_() {
        return (T)this.getInstance().m_203334_();
    }

    public boolean m_203633_() {
        return true;
    }

    public boolean m_203373_(ResourceLocation location) {
        return this.registryKey.m_135782_().equals((Object)location);
    }

    public boolean m_203565_(ResourceKey<T> resourceKey) {
        return resourceKey == this.key;
    }

    public boolean m_203425_(Predicate<ResourceKey<T>> predicate) {
        return predicate.test(this.key);
    }

    public boolean is(Holder<T> other) {
        return other == this || other.m_203543_().get() == this.key;
    }

    public boolean m_203656_(TagKey<T> tagKey) {
        return this.getInstance().m_203656_(tagKey);
    }

    public Stream<TagKey<T>> m_203616_() {
        return this.getInstance().m_203616_();
    }

    public Either<ResourceKey<T>, T> m_203439_() {
        return Either.left(this.key);
    }

    public Optional<ResourceKey<T>> m_203543_() {
        return Optional.of(this.key);
    }

    public Holder.Kind m_203376_() {
        return Holder.Kind.REFERENCE;
    }

    public boolean m_203401_(HolderOwner<T> owner) {
        return this.getInstance().m_203401_(owner);
    }

    public static class Opt<T>
    extends DynamicHolder<T> {
        private boolean resolved = false;

        protected Opt(ResourceKey<Registry<T>> registryKey, ResourceKey<T> key) {
            super(registryKey, key);
        }

        @Override
        @Nullable
        protected Holder<T> getInstance() {
            if (!this.resolved) {
                this.resolved = true;
                try {
                    return super.getInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return (Holder)this.instance.get();
        }

        @Override
        public Stream<TagKey<T>> m_203616_() {
            Holder<T> i = this.getInstance();
            if (i != null) {
                return i.m_203616_();
            }
            return Stream.empty();
        }

        @Override
        public boolean m_203656_(TagKey<T> tagKey) {
            Holder<T> i = this.getInstance();
            if (i != null) {
                return i.m_203656_(tagKey);
            }
            return false;
        }

        @Override
        @Nullable
        public T get() {
            return super.get();
        }

        @Override
        @Nullable
        public T m_203334_() {
            Holder<T> i = this.getInstance();
            if (i != null) {
                return (T)i.m_203334_();
            }
            return null;
        }
    }
}

