/*
 * Decompiled with CFR 0.152.
 */
package net.seikasu.improved_multishot.mixin;

import com.oblivioussp.spartanweaponry.init.ModItems;
import com.oblivioussp.spartanweaponry.item.BoltItem;
import com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"com.oblivioussp.spartanweaponry.item.HeavyCrossbowItem"})
public abstract class HeavyCrossbowMixin {
    @Invoker(value="spawnProjectile")
    public abstract void invokeSpawnProjectile(ItemStack var1, BoltItem var2, ItemStack var3, Level var4, Player var5, boolean var6, float var7, float var8);

    @Inject(method={"releaseUsing"}, at={@At(value="INVOKE", target="Lcom/oblivioussp/spartanweaponry/item/HeavyCrossbowItem;spawnProjectile(Lnet/minecraft/world/item/ItemStack;Lcom/oblivioussp/spartanweaponry/item/BoltItem;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;ZFF)V")}, cancellable=true)
    private void injectExtraMultishot(ItemStack stack, Level level, LivingEntity entity, int timeLeft, CallbackInfo ci) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int multishotLevel = stack.getEnchantmentLevel(Enchantments.f_44959_);
        if (multishotLevel <= 1) {
            return;
        }
        CompoundTag tag = stack.m_41784_().m_128469_("Projectile");
        if (tag == null || tag.m_128456_()) {
            return;
        }
        ItemStack boltStack = ItemStack.m_41712_((CompoundTag)tag);
        if (boltStack.m_41619_()) {
            return;
        }
        boolean creative = player.m_150110_().f_35937_ || boltStack.m_41720_() instanceof BoltItem && ((BoltItem)boltStack.m_41720_()).isInfinite(boltStack, stack, player);
        BoltItem boltItem = (BoltItem)(boltStack.m_41720_() instanceof BoltItem ? boltStack.m_41720_() : (Item)ModItems.BOLT.get());
        HeavyCrossbowItem self = (HeavyCrossbowItem)this;
        int aimTicks = self.getAimTicks(stack);
        int usedTicks = self.m_8105_(stack) - timeLeft;
        int inaccuracy = Mth.m_14045_((int)(aimTicks - usedTicks), (int)0, (int)aimTicks);
        float inaccuracyModifier = inaccuracy == 0 ? 0.0f : 12.0f * ((float)inaccuracy / (float)aimTicks);
        int totalBolts = multishotLevel + 2;
        float totalSpread = 20.0f;
        ci.cancel();
        for (int i = 0; i < totalBolts; ++i) {
            float angle = -totalSpread / 2.0f + (float)i * (totalSpread / (float)(totalBolts - 1));
            this.invokeSpawnProjectile(stack, boltItem, boltStack.m_41777_(), level, player, creative, inaccuracyModifier, angle);
        }
        int damage = totalBolts;
        stack.m_41622_(damage, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
        CompoundTag stackTag = stack.m_41784_();
        stackTag.m_128379_("Charged", false);
        stackTag.m_128365_("Projectile", (Tag)new CompoundTag());
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.NEUTRAL, 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 1.2f) + 0.75f);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
    }
}

